/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import io.smallrye.faulttolerance.CommandListener;
import io.smallrye.faulttolerance.CommandListenersProvider;
import io.smallrye.faulttolerance.CompositeCommand;
import io.smallrye.faulttolerance.CompositeObservableCommand;
import io.smallrye.faulttolerance.DefaultMethodFallbackProvider;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.FailureNotHandledException;
import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.HystrixCommandBinding;
import io.smallrye.faulttolerance.RetryContext;
import io.smallrye.faulttolerance.SecurityActions;
import io.smallrye.faulttolerance.SimpleCommand;
import io.smallrye.faulttolerance.SynchronousCircuitBreaker;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.metrics.BulkheadWaitRecorder;
import io.smallrye.faulttolerance.metrics.MetricsCollector;
import io.smallrye.faulttolerance.metrics.MetricsCollectorFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.Subscription;

@Interceptor
@HystrixCommandBinding
@Priority(value=4010)
public class HystrixCommandInterceptor {
    public static final String SYNC_CIRCUIT_BREAKER_KEY = "io_smallrye_faulttolerance_syncCircuitBreaker";
    public static final String ASYNC_TIMEOUT_KEY = "io_smallrye_faulttolerance_asyncTimeout";
    private static final Logger LOGGER = Logger.getLogger(HystrixCommandInterceptor.class);
    private final ConcurrentMap<String, HystrixCircuitBreaker> circuitBreakers;
    private final ConcurrentMap<Method, CommandMetadata> commandMetadataCache;
    private final Boolean nonFallBackEnable;
    private final Boolean syncCircuitBreakerEnabled;
    private final boolean asyncTimeout;
    private final FallbackHandlerProvider fallbackHandlerProvider;
    private final FaultToleranceOperationProvider faultToleranceOperationProvider;
    private final CommandListenersProvider listenersProvider;
    private final Bean<?> interceptedBean;
    private final MetricsCollectorFactory metricsCollectorFactory;

    @Inject
    public HystrixCommandInterceptor(@ConfigProperty(name="MP_Fault_Tolerance_NonFallback_Enabled", defaultValue="true") Boolean nonFallBackEnable, Config config, FallbackHandlerProvider fallbackHandlerProvider, FaultToleranceOperationProvider faultToleranceOperationProvider, CommandListenersProvider listenersProvider, @Intercepted Bean<?> interceptedBean, MetricsCollectorFactory metricsCollectorFactory) {
        this.nonFallBackEnable = nonFallBackEnable;
        this.syncCircuitBreakerEnabled = config.getOptionalValue(SYNC_CIRCUIT_BREAKER_KEY, Boolean.class).orElse(true);
        this.asyncTimeout = config.getOptionalValue(ASYNC_TIMEOUT_KEY, Boolean.class).orElse(false);
        this.fallbackHandlerProvider = fallbackHandlerProvider;
        this.faultToleranceOperationProvider = faultToleranceOperationProvider;
        this.commandMetadataCache = new ConcurrentHashMap<Method, CommandMetadata>();
        this.listenersProvider = listenersProvider;
        this.interceptedBean = interceptedBean;
        this.metricsCollectorFactory = metricsCollectorFactory;
        try {
            Field field = SecurityActions.getDeclaredField(HystrixCircuitBreaker.Factory.class, "circuitBreakersByCommand");
            SecurityActions.setAccessible(field);
            this.circuitBreakers = (ConcurrentHashMap)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not obtain reference to com.netflix.hystrix.HystrixCircuitBreaker.Factory.circuitBreakersByCommand", e);
        }
    }

    @AroundInvoke
    public Object interceptCommand(InvocationContext invocationContext) throws Exception {
        Class<?> beanClass;
        Method method = invocationContext.getMethod();
        CommandMetadata metadata = this.commandMetadataCache.computeIfAbsent(method, arg_0 -> this.lambda$interceptCommand$0(beanClass = this.interceptedBean != null ? this.interceptedBean.getBeanClass() : invocationContext.getTarget().getClass(), method, arg_0));
        FaultToleranceOperation operation = metadata.operation;
        if (!operation.isLegitimate()) {
            return invocationContext.proceed();
        }
        ExecutionContextWithInvocationContext ctx = new ExecutionContextWithInvocationContext(invocationContext);
        LOGGER.tracef("FT operation intercepted: %s", (Object)method);
        RetryContext retryContext = this.nonFallBackEnable != false && operation.hasRetry() ? new RetryContext(operation.getRetry()) : null;
        SynchronousCircuitBreaker syncCircuitBreaker = this.getSynchronousCircuitBreaker(metadata);
        Cancelator cancelator = new Cancelator(retryContext);
        if (operation.isAsync()) {
            LOGGER.debugf("Queue up command for async execution: %s", (Object)operation);
            Function<Supplier, SimpleCommand> commandFactory = fallback -> {
                MetricRegistry metricRegistry = this.metricsCollectorFactory.isMetricsEnabled() ? this.metricsCollectorFactory.getRegistry() : null;
                List<CommandListener> commandListeners = this.listenersProvider.getCommandListeners();
                if (metricRegistry != null && operation.hasBulkhead()) {
                    commandListeners = commandListeners == null ? new ArrayList<CommandListener>() : new ArrayList<CommandListener>(commandListeners);
                    commandListeners.add(new BulkheadWaitRecorder(metricRegistry));
                }
                SimpleCommand simpleCommand = new SimpleCommand(metadata.setter, ctx, (Supplier<Object>)fallback, operation, (Iterable<CommandListener>)commandListeners, retryContext);
                cancelator.setCommand(simpleCommand);
                return simpleCommand;
            };
            Callable<Object> callable = () -> this.executeCommand(commandFactory, null, metadata, ctx, syncCircuitBreaker);
            if (operation.returnsCompletionStage()) {
                HystrixObservableCommand<?> command = CompositeObservableCommand.create(callable, operation, retryContext, ctx, this.metricsCollectorFactory.isMetricsEnabled() ? this.metricsCollectorFactory.getRegistry() : null, this.asyncTimeout);
                return new ObservableCompletableFuture(command.observe(), retryContext, method, syncCircuitBreaker);
            }
            try {
                Future<Object> future = CompositeCommand.createAndQueue(callable, operation, retryContext, ctx, this.metricsCollectorFactory.isMetricsEnabled() ? this.metricsCollectorFactory.getRegistry() : null, this.asyncTimeout);
                return new AsyncFuture(future, cancelator);
            }
            catch (HystrixRuntimeException e) {
                if (e.getFailureType() == HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION) {
                    return new FailedFuture((Exception)new BulkheadException((Throwable)e));
                }
                throw e;
            }
        }
        Function<Supplier<Object>, SimpleCommand> commandFactory = fallback -> {
            SimpleCommand simpleCommand = new SimpleCommand(metadata.setter, ctx, (Supplier<Object>)fallback, operation, (Iterable<CommandListener>)this.listenersProvider.getCommandListeners(), retryContext);
            cancelator.setCommand(simpleCommand);
            return simpleCommand;
        };
        LOGGER.debugf("Sync execution: %s]", (Object)operation);
        return this.executeCommand(commandFactory, retryContext, metadata, ctx, syncCircuitBreaker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeCommand(Function<Supplier<Object>, SimpleCommand> commandFactory, RetryContext retryContext, CommandMetadata metadata, ExecutionContextWithInvocationContext ctx, SynchronousCircuitBreaker syncCircuitBreaker) throws Exception {
        MetricsCollector metricsCollector = this.metricsCollectorFactory.createCollector(metadata.operation, retryContext, metadata.poolKey);
        metricsCollector.init(syncCircuitBreaker);
        while (true) {
            if (retryContext != null) {
                LOGGER.debugf("Executing %s with %s", (Object)metadata.operation, (Object)retryContext);
            }
            SimpleCommand command = commandFactory.apply(metadata.getFallback(ctx));
            metricsCollector.beforeExecute(command);
            try {
                Object res = command.execute();
                if (syncCircuitBreaker != null) {
                    if (command.isFailedExecution() && syncCircuitBreaker.failsOn(command.getFailedExecutionException())) {
                        syncCircuitBreaker.executionFailed();
                    } else {
                        syncCircuitBreaker.executionSucceeded();
                    }
                }
                metricsCollector.afterSuccess(command);
                Object object = res;
                return object;
            }
            catch (HystrixRuntimeException e) {
                metricsCollector.onError(command, e);
                Exception res = HystrixCommandInterceptor.processHystrixRuntimeException(e, retryContext, metadata.operation.getMethod(), syncCircuitBreaker);
                metricsCollector.onProcessedError(command, res);
                if (res == null) continue;
                throw res;
            }
            finally {
                metricsCollector.afterExecute(command);
                continue;
            }
            break;
        }
    }

    private static Exception processHystrixRuntimeException(HystrixRuntimeException e, RetryContext retryContext, Method method, SynchronousCircuitBreaker syncCircuitBreaker) {
        HystrixRuntimeException.FailureType failureType = e.getFailureType();
        LOGGER.tracef("Hystrix runtime failure [%s] with cause %s when invoking %s", (Object)failureType, (Object)e.getCause(), (Object)method);
        Throwable fallbackException = e.getFallbackException();
        if (fallbackException instanceof FailureNotHandledException) {
            FailureNotHandledException failureNotHandledException = (FailureNotHandledException)fallbackException;
            return (Exception)failureNotHandledException.getCause();
        }
        if (syncCircuitBreaker != null) {
            if (syncCircuitBreaker.failsOn(HystrixCommandInterceptor.getCause(e))) {
                syncCircuitBreaker.executionFailed();
            } else {
                syncCircuitBreaker.executionSucceeded();
            }
        }
        switch (failureType) {
            case TIMEOUT: {
                TimeoutException timeoutException = new TimeoutException((Throwable)e);
                if (retryContext != null && retryContext.shouldRetry()) {
                    return retryContext.nextRetry((Throwable)timeoutException);
                }
                return timeoutException;
            }
            case SHORTCIRCUIT: {
                CircuitBreakerOpenException circuitBreakerOpenException = new CircuitBreakerOpenException(method.getName());
                if (retryContext != null && retryContext.shouldRetry()) {
                    return retryContext.nextRetry((Throwable)circuitBreakerOpenException);
                }
                return circuitBreakerOpenException;
            }
            case REJECTED_THREAD_EXECUTION: 
            case REJECTED_SEMAPHORE_EXECUTION: 
            case REJECTED_SEMAPHORE_FALLBACK: {
                BulkheadException bulkheadException = new BulkheadException((Throwable)e);
                if (retryContext != null && retryContext.shouldRetry()) {
                    return retryContext.nextRetry((Throwable)bulkheadException);
                }
                return bulkheadException;
            }
            case COMMAND_EXCEPTION: {
                if (retryContext == null || !retryContext.shouldRetry()) break;
                return retryContext.nextRetry(HystrixCommandInterceptor.getRetryCause(e));
            }
        }
        return HystrixCommandInterceptor.getCause(e);
    }

    private static Throwable getRetryCause(HystrixRuntimeException e) {
        if (e.getCause() instanceof Exception) {
            if (HystrixCommandInterceptor.isHystrixWrapperForThrowable((Exception)e.getCause())) {
                return e.getCause().getCause();
            }
            return e.getCause();
        }
        return e;
    }

    private static boolean isHystrixWrapperForThrowable(Exception e) {
        return e.getClass() == Exception.class && e.getStackTrace() != null && e.getStackTrace().length > 0 && "com.netflix.hystrix.AbstractCommand".equals(e.getStackTrace()[0].getClassName());
    }

    private static Exception getCause(HystrixRuntimeException e) {
        return e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
    }

    private SynchronousCircuitBreaker getSynchronousCircuitBreaker(CommandMetadata metadata) {
        if (this.nonFallBackEnable.booleanValue() && this.syncCircuitBreakerEnabled.booleanValue() && metadata.hasCircuitBreaker()) {
            HystrixCircuitBreaker circuitBreaker = this.circuitBreakers.computeIfAbsent(metadata.commandKey.name(), key -> new SynchronousCircuitBreaker(metadata.operation.getCircuitBreaker()));
            if (circuitBreaker instanceof SynchronousCircuitBreaker) {
                return (SynchronousCircuitBreaker)circuitBreaker;
            }
            throw new IllegalStateException("Cached circuit breaker does not extend SynchronousCircuitBreaker");
        }
        return null;
    }

    private static IllegalStateException errorProcessingHystrixRuntimeException(HystrixRuntimeException e) {
        return new IllegalStateException("Error during processing hystrix runtime exception", e);
    }

    private HystrixCommand.Setter initCommandSetter(HystrixCommandKey commandKey, HystrixThreadPoolKey poolKey, Method method, FaultToleranceOperation operation) {
        HystrixCommandProperties.Setter propertiesSetter = HystrixCommandProperties.Setter();
        if (operation.isAsync() || operation.hasTimeout()) {
            propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
        } else {
            propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
        }
        if (this.nonFallBackEnable.booleanValue() && operation.hasTimeout()) {
            Long value = Duration.of((Long)operation.getTimeout().get("value"), (TemporalUnit)operation.getTimeout().get("unit")).toMillis();
            if (value > Integer.MAX_VALUE) {
                LOGGER.warnf("Max supported value for @Timeout.value() is %s", (Object)Integer.MAX_VALUE);
                value = Integer.MAX_VALUE;
            }
            propertiesSetter.withExecutionTimeoutInMilliseconds(value.intValue());
            propertiesSetter.withExecutionIsolationThreadInterruptOnTimeout(true);
        } else {
            propertiesSetter.withExecutionTimeoutEnabled(false);
        }
        if (this.nonFallBackEnable.booleanValue() && operation.hasCircuitBreaker()) {
            propertiesSetter.withCircuitBreakerEnabled(true).withCircuitBreakerRequestVolumeThreshold(((Integer)operation.getCircuitBreaker().get("requestVolumeThreshold")).intValue()).withCircuitBreakerErrorThresholdPercentage(new Double((Double)operation.getCircuitBreaker().get("failureRatio") * 100.0).intValue()).withCircuitBreakerSleepWindowInMilliseconds((int)Duration.of((Long)operation.getCircuitBreaker().get("delay"), (TemporalUnit)operation.getCircuitBreaker().get("delayUnit")).toMillis());
        } else {
            propertiesSetter.withCircuitBreakerEnabled(false);
        }
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"DefaultCommandGroup")).andCommandKey(commandKey).andCommandPropertiesDefaults(propertiesSetter).andThreadPoolKey(poolKey);
        if (this.nonFallBackEnable.booleanValue() && operation.hasBulkhead()) {
            BulkheadConfig bulkhead = operation.getBulkhead();
            if (operation.isAsync()) {
                HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
                threadPoolSetter.withAllowMaximumSizeToDivergeFromCoreSize(false).withCoreSize(((Integer)bulkhead.get("value")).intValue()).withMaximumSize(((Integer)bulkhead.get("value")).intValue()).withMaxQueueSize(((Integer)bulkhead.get("waitingTaskQueue")).intValue()).withQueueSizeRejectionThreshold(((Integer)bulkhead.get("waitingTaskQueue")).intValue());
                setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
            } else {
                propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
                propertiesSetter.withExecutionIsolationSemaphoreMaxConcurrentRequests(((Integer)bulkhead.get("value")).intValue());
                propertiesSetter.withExecutionIsolationThreadInterruptOnFutureCancel(true);
            }
        }
        return setter;
    }

    private static ExecutionException unwrapExecutionException(ExecutionException e) throws ExecutionException {
        if (e.getCause() instanceof HystrixRuntimeException) {
            HystrixRuntimeException hystrixRuntimeException = (HystrixRuntimeException)e.getCause();
            Exception res = HystrixRuntimeException.FailureType.COMMAND_EXCEPTION.equals((Object)hystrixRuntimeException.getFailureType()) ? HystrixCommandInterceptor.getCause(hystrixRuntimeException) : HystrixCommandInterceptor.errorProcessingHystrixRuntimeException(hystrixRuntimeException);
            return new ExecutionException(res);
        }
        return e;
    }

    private static IllegalStateException unableToUnwrap(Future<Object> future) {
        return new IllegalStateException("Unable to get the result of: " + future);
    }

    private /* synthetic */ CommandMetadata lambda$interceptCommand$0(Class beanClass, Method method, Method k) {
        return new CommandMetadata(beanClass, method);
    }

    private class Cancelator {
        private final RetryContext retryContext;
        private SimpleCommand command;
        private AtomicBoolean canceled = new AtomicBoolean(false);

        Cancelator(RetryContext retryContext) {
            this.retryContext = retryContext;
        }

        void setCommand(SimpleCommand command) {
            this.command = command;
            if (this.canceled.get()) {
                this.cancel(true);
            }
        }

        void cancel(boolean mayInterruptIfRunning) {
            this.canceled.set(true);
            if (this.retryContext != null) {
                this.retryContext.cancel();
            }
            this.command.cancel(mayInterruptIfRunning);
        }
    }

    static class FailedFuture
    implements Future<Object> {
        private final Exception error;

        FailedFuture(Exception error) {
            this.error = error;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Object get() throws ExecutionException {
            throw new ExecutionException(this.error);
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws ExecutionException {
            throw new ExecutionException(this.error);
        }
    }

    static class AsyncFuture
    implements Future<Object> {
        private final Future<Object> delegate;
        private final Cancelator cancelator;

        public AsyncFuture(Future<Object> delegate, Cancelator cancelator) {
            this.delegate = delegate;
            this.cancelator = cancelator;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelator.cancel(mayInterruptIfRunning);
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            Future<Object> future;
            try {
                future = this.unwrapFuture(this.delegate.get());
            }
            catch (ExecutionException e) {
                ExecutionException executionException = HystrixCommandInterceptor.unwrapExecutionException(e);
                if (this.isCancellation(executionException)) {
                    throw new CancellationException();
                }
                throw executionException;
            }
            try {
                return this.logResult(future, future.get());
            }
            catch (ExecutionException e) {
                if (this.isCancellation(e)) {
                    throw new CancellationException();
                }
                throw e;
            }
            catch (Exception e) {
                throw HystrixCommandInterceptor.unableToUnwrap(future);
            }
        }

        private boolean isCancellation(ExecutionException executionException) {
            return this.cancelator.canceled.get() && executionException.getCause() instanceof InterruptedException;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            Future<Object> future;
            try {
                future = this.unwrapFuture(this.delegate.get());
            }
            catch (ExecutionException e) {
                ExecutionException executionException = HystrixCommandInterceptor.unwrapExecutionException(e);
                if (this.isCancellation(executionException)) {
                    throw new CancellationException();
                }
                throw executionException;
            }
            try {
                return this.logResult(future, future.get(timeout, unit));
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw HystrixCommandInterceptor.unableToUnwrap(future);
            }
        }

        private Future<Object> unwrapFuture(Object futureObject) {
            if (futureObject instanceof Future) {
                return (Future)futureObject;
            }
            throw new IllegalStateException("A result of an @Asynchronous call must be Future: " + futureObject);
        }

        private Object logResult(Future<Object> future, Object unwrapped) {
            LOGGER.tracef("Unwrapped async result from %s: %s", future, unwrapped);
            return unwrapped;
        }
    }

    static class ObservableCompletableFuture<T>
    extends CompletableFuture<T> {
        private final Subscription subscription;
        private final RetryContext retryContext;
        private final Method method;
        private final SynchronousCircuitBreaker syncCircuitBreaker;

        ObservableCompletableFuture(Observable<T> observable, RetryContext retryContext, Method method, SynchronousCircuitBreaker syncCircuitBreaker) {
            this.retryContext = retryContext;
            this.method = method;
            this.syncCircuitBreaker = syncCircuitBreaker;
            this.subscription = observable.single().subscribe(this::complete, this::completeExceptionally);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            if (ex instanceof HystrixRuntimeException) {
                return super.completeExceptionally(HystrixCommandInterceptor.processHystrixRuntimeException((HystrixRuntimeException)ex, this.retryContext, this.method, this.syncCircuitBreaker));
            }
            return super.completeExceptionally(ex);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.subscription.unsubscribe();
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private class CommandMetadata {
        private final HystrixCommand.Setter setter;
        private final HystrixCommandKey commandKey;
        private final HystrixThreadPoolKey poolKey;
        private final Method fallbackMethod;
        private final FaultToleranceOperation operation;

        CommandMetadata(Class<?> beanClass, Method method) {
            this.operation = HystrixCommandInterceptor.this.faultToleranceOperationProvider.get(beanClass, method);
            this.commandKey = HystrixCommandKey.Factory.asKey((String)SimpleCommand.getCommandKey(method));
            this.poolKey = HystrixCommandInterceptor.this.nonFallBackEnable != false && this.operation.hasBulkhead() && this.operation.isAsync() ? HystrixThreadPoolKey.Factory.asKey((String)this.commandKey.name()) : HystrixThreadPoolKey.Factory.asKey((String)"DefaultCommandGroup");
            this.setter = HystrixCommandInterceptor.this.initCommandSetter(this.commandKey, this.poolKey, method, this.operation);
            if (this.operation.hasFallback()) {
                FallbackConfig fallbackConfig = this.operation.getFallback();
                if (!fallbackConfig.get("value").equals(Fallback.DEFAULT.class)) {
                    this.fallbackMethod = null;
                } else {
                    String fallbackMethodName = (String)fallbackConfig.get("fallbackMethod");
                    if (!"".equals(fallbackMethodName)) {
                        try {
                            this.fallbackMethod = SecurityActions.getDeclaredMethod(beanClass, method.getDeclaringClass(), fallbackMethodName, method.getGenericParameterTypes());
                            if (this.fallbackMethod == null) {
                                throw new FaultToleranceException("Could not obtain fallback method " + fallbackMethodName);
                            }
                            SecurityActions.setAccessible(this.fallbackMethod);
                        }
                        catch (PrivilegedActionException e) {
                            throw new FaultToleranceException("Could not obtain fallback method", (Throwable)e);
                        }
                    } else {
                        this.fallbackMethod = null;
                    }
                }
            } else {
                this.fallbackMethod = null;
            }
        }

        boolean hasCircuitBreaker() {
            return this.operation.hasCircuitBreaker();
        }

        Supplier<Object> getFallback(ExecutionContextWithInvocationContext ctx) {
            Supplier<Object> fallback = null;
            if (this.fallbackMethod != null) {
                fallback = () -> {
                    try {
                        if (this.fallbackMethod.isDefault()) {
                            return DefaultMethodFallbackProvider.getFallback(this.fallbackMethod, ctx);
                        }
                        return this.fallbackMethod.invoke(ctx.getTarget(), ctx.getParameters());
                    }
                    catch (Throwable e) {
                        throw new FaultToleranceException("Error during fallback method invocation", e);
                    }
                };
            } else {
                FallbackHandler fallbackHandler = HystrixCommandInterceptor.this.fallbackHandlerProvider.get(this.operation);
                if (fallbackHandler != null) {
                    fallback = () -> fallbackHandler.handle((ExecutionContext)ctx);
                }
            }
            return fallback;
        }
    }
}

