/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.GenericConfig;
import io.smallrye.faulttolerance.config.SecurityActions;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FallbackConfig
extends GenericConfig<Fallback> {
    public static final String VALUE = "value";
    public static final String FALLBACK_METHOD = "fallbackMethod";
    private static Map<String, Class<?>> keys2Type = FallbackConfig.initKeys();

    public FallbackConfig(Class<?> beanClass, Method method) {
        super(Fallback.class, beanClass, method);
    }

    public FallbackConfig(AnnotatedMethod<?> annotatedMethod) {
        super(Fallback.class, annotatedMethod);
    }

    @Override
    public void validate() {
        if (!"".equals(this.get(FALLBACK_METHOD))) {
            Method fallbackMethod;
            if (!Fallback.DEFAULT.class.equals(this.get(VALUE))) {
                throw new FaultToleranceDefinitionException("Fallback configuration can't contain an handler class and method at the same time");
            }
            try {
                fallbackMethod = SecurityActions.getDeclaredMethod(this.beanClass, this.method.getDeclaringClass(), (String)this.get(FALLBACK_METHOD), this.method.getGenericParameterTypes());
            }
            catch (PrivilegedActionException e) {
                throw new FaultToleranceDefinitionException("Fallback method " + this.get(FALLBACK_METHOD) + " with same parameters as " + this.method.getName() + " not found", (Throwable)e);
            }
            if (fallbackMethod == null) {
                throw new FaultToleranceDefinitionException("Fallback method " + this.get(FALLBACK_METHOD) + " with same parameters as " + this.method.getName() + " not found");
            }
            if (!this.method.getReturnType().equals(Void.TYPE) && !FallbackConfig.isAssignableFrom(this.method.getGenericReturnType(), fallbackMethod.getGenericReturnType())) {
                throw new FaultToleranceDefinitionException("Fallback method " + this.get(FALLBACK_METHOD) + " must have a return type assignable to " + this.method.getName());
            }
        }
        if (!Fallback.DEFAULT.class.equals(this.get(VALUE))) {
            Class fbhc = (Class)this.get(VALUE);
            Type fallbackType = null;
            for (Type genericInterface : fbhc.getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(genericInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericInterface).getRawType().equals(FallbackHandler.class)) continue;
                fallbackType = parameterizedType.getActualTypeArguments()[0];
                break;
            }
            if (fallbackType == null || !this.method.getGenericReturnType().equals(fallbackType)) {
                throw new FaultToleranceDefinitionException("Fallback handler type [" + fallbackType + "] is not the same as the method return type: " + this.method);
            }
        }
    }

    @Override
    protected Class<Fallback> getConfigType() {
        return Fallback.class;
    }

    @Override
    protected Map<String, Class<?>> getKeysToType() {
        return keys2Type;
    }

    private static Map<String, Class<?>> initKeys() {
        HashMap<String, Class> keys = new HashMap<String, Class>();
        keys.put(VALUE, Class.class);
        keys.put(FALLBACK_METHOD, String.class);
        return Collections.unmodifiableMap(keys);
    }

    private static boolean isAssignableFrom(Type type1, Type type2) {
        if (type1 instanceof Class) {
            if (type2 instanceof Class) {
                return FallbackConfig.isAssignableFrom((Class)type1, (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return FallbackConfig.isAssignableFrom((Type)((Class)type1), (Type)((ParameterizedType)type2));
            }
            throw new IllegalArgumentException("Unsupported type " + type2);
        }
        if (type1 instanceof ParameterizedType) {
            if (type2 instanceof ParameterizedType) {
                return FallbackConfig.isAssignableFrom((ParameterizedType)type1, (ParameterizedType)type2);
            }
            throw new IllegalArgumentException("Unsupported type " + type2);
        }
        throw new IllegalArgumentException("Unsupported type " + type1);
    }

    private static boolean isAssignableFrom(Class<?> type1, Class<?> type2) {
        return type1.isAssignableFrom(type2);
    }

    private static boolean isAssignableFrom(ParameterizedType type1, ParameterizedType type2) {
        Type[] types2;
        Class rawType2;
        Class rawType1 = (Class)type1.getRawType();
        if (!rawType1.equals(rawType2 = (Class)type2.getRawType())) {
            return false;
        }
        Type[] types1 = type1.getActualTypeArguments();
        if (types1.length != (types2 = type2.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < type1.getActualTypeArguments().length; ++i) {
            if (FallbackConfig.isAssignableFrom(types1[i], types2[i])) continue;
            return false;
        }
        return true;
    }
}

