/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.exception.HystrixTimeoutException;
import io.smallrye.faulttolerance.BasicCommand;
import io.smallrye.faulttolerance.CommandListener;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.FailureNotHandledException;
import io.smallrye.faulttolerance.RetryContext;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

public class SimpleCommand
extends BasicCommand {
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private Thread executionThread;
    private final FaultToleranceOperation operation;
    private final Supplier<Object> fallback;
    private final ExecutionContextWithInvocationContext ctx;
    private final Iterable<CommandListener> listeners;
    private final RetryContext retryContext;

    public static String getCommandKey(Method method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getDeclaringClass().getName().replace(".", "_"));
        builder.append("#");
        builder.append(method.getName());
        builder.append("(");
        Type[] params = method.getGenericParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            builder.append(params[j].getTypeName());
            if (j >= params.length - 1) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    protected SimpleCommand(HystrixCommand.Setter setter, ExecutionContextWithInvocationContext ctx, Supplier<Object> fallback, FaultToleranceOperation operation, Iterable<CommandListener> listeners, RetryContext retryContext) {
        super(setter);
        this.ctx = ctx;
        this.fallback = fallback;
        this.operation = operation;
        this.listeners = listeners;
        this.retryContext = retryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object run() throws Exception {
        this.executionThread = Thread.currentThread();
        if (this.canceled.get()) {
            return null;
        }
        if (this.listeners == null) {
            return this.ctx.proceed();
        }
        try {
            for (CommandListener listener : this.listeners) {
                listener.beforeExecution(this.operation);
            }
            Object object = this.ctx.proceed();
            return object;
        }
        finally {
            for (CommandListener listener : this.listeners) {
                listener.afterExecution(this.operation);
            }
        }
    }

    protected Object getFallback() {
        if (this.fallback == null) {
            return super.getFallback();
        }
        Throwable failure = this.getFailedExecutionException();
        if (failure != null && this.operation.hasCircuitBreaker() && !this.isFailureAssignableFromAnyFailureException(failure)) {
            throw new FailureNotHandledException(failure);
        }
        if (failure == null) {
            failure = this.translateException();
        }
        if (this.retryContext == null || !this.retryContext.shouldRetryOn(failure)) {
            return this.fallback.get();
        }
        return super.getFallback();
    }

    private Throwable translateException() {
        Exception e = this.executionResult.getExecutionException();
        if (e instanceof HystrixTimeoutException) {
            return new TimeoutException((Throwable)e);
        }
        switch (e.getMessage()) {
            case "could not acquire a semaphore for execution": {
                return new BulkheadException((Throwable)e);
            }
            case "Hystrix circuit short-circuited and is OPEN": {
                return new CircuitBreakerOpenException((Throwable)e);
            }
        }
        return e;
    }

    private boolean isFailureAssignableFromAnyFailureException(Throwable failure) {
        Class[] exceptions;
        for (Class exception : exceptions = (Class[])this.operation.getCircuitBreaker().get("failOn")) {
            if (!exception.isAssignableFrom(failure.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    void setFailure(Throwable f) {
        this.ctx.setFailure(f);
    }

    @Override
    FaultToleranceOperation getOperation() {
        return this.operation;
    }

    public HystrixCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void cancel(boolean mayInterrupt) {
        this.canceled.set(true);
        if (mayInterrupt && this.executionThread != null) {
            this.executionThread.interrupt();
        }
    }
}

