/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.smallrye.faulttolerance.CompositeCommand;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.RetryContext;
import io.smallrye.faulttolerance.SecurityActions;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.metrics.MetricNames;
import io.smallrye.faulttolerance.metrics.MetricsCollectorFactory;
import java.lang.reflect.Field;
import java.security.PrivilegedActionException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import rx.Observable;

public class CompositeObservableCommand
extends HystrixObservableCommand {
    private final Callable<? extends CompletionStage<?>> callable;
    private final ExecutionContextWithInvocationContext ctx;
    private final FaultToleranceOperation operation;
    private final RetryContext retryContext;
    private final MetricRegistry registry;
    private final Supplier<Object> fallback;

    public static HystrixObservableCommand<?> create(Callable<? extends CompletionStage<?>> callable, FaultToleranceOperation operation, RetryContext retryContext, ExecutionContextWithInvocationContext ctx, MetricRegistry registry, boolean timeoutEnabled, Supplier<Object> fallback) {
        return new CompositeObservableCommand(callable, operation, retryContext, ctx, registry, timeoutEnabled, fallback);
    }

    protected CompositeObservableCommand(Callable<? extends CompletionStage<?>> callable, FaultToleranceOperation operation, RetryContext retryContext, ExecutionContextWithInvocationContext ctx, MetricRegistry registry, boolean timeoutEnabled, Supplier<Object> fallback) {
        super(CompositeObservableCommand.initSetter(operation, timeoutEnabled));
        this.callable = callable;
        this.ctx = ctx;
        this.operation = operation;
        this.retryContext = retryContext;
        this.registry = registry;
        this.fallback = fallback;
    }

    protected Observable<?> construct() {
        String metricsPrefix = MetricNames.metricsPrefix(this.operation.getMethod());
        Observable observable = Observable.create(subscriber -> {
            try {
                CompletionStage<?> stage;
                if (this.registry != null && this.retryContext != null && this.retryContext.hasBeenRetried()) {
                    this.counterOf(metricsPrefix + ".retry.retries.total").inc();
                }
                if ((stage = this.callable.call()) == null) {
                    subscriber.onError((Throwable)new NullPointerException("A method that should return a CompletionStage returned null"));
                } else {
                    stage.whenComplete((value, error) -> {
                        if (error == null) {
                            if (this.registry != null && this.retryContext != null) {
                                if (this.retryContext.hasBeenRetried()) {
                                    this.counterOf(metricsPrefix + ".retry.callsSucceededRetried.total").inc();
                                } else {
                                    this.counterOf(metricsPrefix + ".retry.callsSucceededNotRetried.total").inc();
                                }
                            }
                            subscriber.onNext(value);
                            subscriber.onCompleted();
                        } else {
                            subscriber.onError(error);
                        }
                    });
                }
            }
            catch (Exception e) {
                subscriber.onError((Throwable)e);
            }
        });
        if (this.retryContext != null) {
            return observable.retryWhen(attempts -> attempts.flatMap(error -> {
                if (this.retryContext.shouldRetry()) {
                    Exception shouldRetry = null;
                    try {
                        shouldRetry = this.retryContext.nextRetry((Throwable)error);
                    }
                    catch (Throwable e) {
                        return Observable.error((Throwable)e);
                    }
                    if (shouldRetry != null) {
                        return Observable.error((Throwable)shouldRetry);
                    }
                    return Observable.just((Object)"");
                }
                if (this.registry != null) {
                    this.counterOf(metricsPrefix + ".retry.callsFailed.total").inc();
                }
                return Observable.error((Throwable)error);
            }));
        }
        return observable;
    }

    private static HystrixObservableCommand.Setter initSetter(FaultToleranceOperation operation, boolean timeoutEnabled) {
        HystrixCommandKey commandKey = CompositeCommand.hystrixCommandKey(operation);
        HystrixObservableCommand.Setter result = HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)CompositeCommand.hystrixCommandGroupKey()).andCommandKey(commandKey).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withFallbackEnabled(true).withCircuitBreakerEnabled(false).withExecutionTimeoutEnabled(timeoutEnabled));
        try {
            Field threadPoolKey = SecurityActions.getDeclaredField(HystrixObservableCommand.Setter.class, "threadPoolKey");
            SecurityActions.setAccessible(threadPoolKey);
            threadPoolKey.set(result, HystrixThreadPoolKey.Factory.asKey((String)commandKey.name()));
            Field threadPoolPropertiesDefaults = SecurityActions.getDeclaredField(HystrixObservableCommand.Setter.class, "threadPoolPropertiesDefaults");
            SecurityActions.setAccessible(threadPoolPropertiesDefaults);
            threadPoolPropertiesDefaults.set(result, HystrixThreadPoolProperties.Setter().withAllowMaximumSizeToDivergeFromCoreSize(true));
        }
        catch (ReflectiveOperationException | PrivilegedActionException exception) {
            // empty catch block
        }
        return result;
    }

    protected Observable resumeWithFallback() {
        if (this.fallback == null) {
            return super.resumeWithFallback();
        }
        return Observable.create(subscriber -> {
            CompletionStage fallbackFuture = (CompletionStage)this.fallback.get();
            fallbackFuture.whenComplete((result, error) -> {
                if (result != null) {
                    subscriber.onNext(result);
                    subscriber.onCompleted();
                } else {
                    subscriber.onError(error);
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Counter counterOf(String name) {
        MetricID metricID = new MetricID(name);
        Counter counter = (Counter)this.registry.getCounters().get(metricID);
        if (counter == null) {
            FaultToleranceOperation faultToleranceOperation = this.operation;
            synchronized (faultToleranceOperation) {
                counter = (Counter)this.registry.getCounters().get(metricID);
                if (counter == null) {
                    counter = this.registry.counter(MetricsCollectorFactory.metadataOf(name, MetricType.COUNTER));
                }
            }
        }
        return counter;
    }
}

