/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.CommandListener;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.metrics.MetricNames;
import io.smallrye.faulttolerance.metrics.MetricsCollectorFactory;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.logging.Logger;

public class BulkheadWaitRecorder
implements CommandListener {
    private static final Logger LOGGER = Logger.getLogger(BulkheadWaitRecorder.class);
    private final long enqueuedTime;
    private final MetricRegistry registry;

    public BulkheadWaitRecorder(MetricRegistry registry) {
        this.registry = registry;
        this.enqueuedTime = System.nanoTime();
    }

    @Override
    public void beforeExecution(FaultToleranceOperation operation) {
        try {
            this.histogramOf(operation).update(System.nanoTime() - this.enqueuedTime);
        }
        catch (Exception any) {
            LOGGER.warn((Object)"Failed to update metrics", (Throwable)any);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Histogram histogramOf(FaultToleranceOperation operation) {
        String name = MetricNames.metricsPrefix(operation.getMethod()) + ".bulkhead.waiting.duration";
        MetricID metricID = new MetricID(name);
        Histogram histogram = (Histogram)this.registry.getHistograms().get(metricID);
        if (histogram == null) {
            FaultToleranceOperation faultToleranceOperation = operation;
            synchronized (faultToleranceOperation) {
                histogram = (Histogram)this.registry.getHistograms().get(metricID);
                if (histogram == null) {
                    histogram = this.registry.histogram(MetricsCollectorFactory.metadataOf(name, MetricType.HISTOGRAM));
                }
            }
        }
        return histogram;
    }
}

