/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.AsyncTypes;
import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.DefaultMethodFallbackProvider;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.RequestContextIntegration;
import io.smallrye.faulttolerance.SecurityActions;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.config.GenericConfig;
import io.smallrye.faulttolerance.config.RetryConfig;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.CompletionStageExecution;
import io.smallrye.faulttolerance.core.async.FutureExecution;
import io.smallrye.faulttolerance.core.bulkhead.CompletionStageBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.SemaphoreBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.ThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CompletionStageCircuitBreaker;
import io.smallrye.faulttolerance.core.fallback.CompletionStageFallback;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.metrics.CompletionStageMetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.CompletionStageRetry;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.SimpleBackOff;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.AsyncTimeout;
import io.smallrye.faulttolerance.core.timeout.CompletionStageTimeout;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.timeout.TimerTimeoutWatcher;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.internal.AsyncTypesConversion;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.RequestScopeActivator;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.MetricsProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Priority;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@Interceptor
@FaultToleranceBinding
@Priority(value=4010)
public class FaultToleranceInterceptor {
    private final Bean<?> interceptedBean;
    private final FaultToleranceOperationProvider operationProvider;
    private final StrategyCache cache;
    private final FallbackHandlerProvider fallbackHandlerProvider;
    private final MetricsProvider metricsProvider;
    private final ExecutorService asyncExecutor;
    private final Timer timer;
    private final RequestContextController requestContextController;
    private final CircuitBreakerMaintenanceImpl cbMaintenance;

    @Inject
    public FaultToleranceInterceptor(@Intercepted Bean<?> interceptedBean, FaultToleranceOperationProvider operationProvider, StrategyCache cache, FallbackHandlerProvider fallbackHandlerProvider, MetricsProvider metricsProvider, ExecutorHolder executorHolder, RequestContextIntegration requestContextIntegration, CircuitBreakerMaintenanceImpl cbMaintenance) {
        this.interceptedBean = interceptedBean;
        this.operationProvider = operationProvider;
        this.cache = cache;
        this.fallbackHandlerProvider = fallbackHandlerProvider;
        this.metricsProvider = metricsProvider;
        this.asyncExecutor = executorHolder.getAsyncExecutor();
        this.timer = executorHolder.getTimer();
        this.requestContextController = requestContextIntegration.get();
        this.cbMaintenance = cbMaintenance;
    }

    @AroundInvoke
    public Object interceptCommand(javax.interceptor.InvocationContext interceptionContext) throws Exception {
        Method method = interceptionContext.getMethod();
        Class beanClass = this.interceptedBean != null ? this.interceptedBean.getBeanClass() : method.getDeclaringClass();
        InterceptionPoint point = new InterceptionPoint(beanClass, interceptionContext);
        FaultToleranceOperation operation = this.operationProvider.get(beanClass, method);
        if ((operation.isAsync() || operation.isAdditionalAsync()) && AsyncTypes.isKnown(operation.getReturnType())) {
            return this.asyncFlow(operation, interceptionContext, point);
        }
        if (operation.isAsync()) {
            return this.futureFlow(operation, interceptionContext, point);
        }
        return this.syncFlow(operation, interceptionContext, point);
    }

    private Object asyncFlow(FaultToleranceOperation operation, javax.interceptor.InvocationContext interceptionContext, InterceptionPoint point) {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareAsyncStrategy(operation, point));
        InvocationContext ctx = this.invocationContext(interceptionContext);
        try {
            return strategy.apply(ctx);
        }
        catch (Exception e) {
            return AsyncTypes.get(operation.getReturnType()).fromCompletionStage(CompletionStages.failedStage((Throwable)e));
        }
    }

    private <T> T syncFlow(FaultToleranceOperation operation, javax.interceptor.InvocationContext interceptionContext, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareSyncStrategy(operation, point));
        InvocationContext<T> ctx = this.invocationContext(interceptionContext);
        return (T)strategy.apply(ctx);
    }

    private <T> Future<T> futureFlow(FaultToleranceOperation operation, javax.interceptor.InvocationContext interceptionContext, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareFutureStrategy(operation, point));
        InvocationContext<T> ctx = this.invocationContext(interceptionContext);
        return (Future)strategy.apply(ctx);
    }

    private <T> InvocationContext<T> invocationContext(javax.interceptor.InvocationContext interceptionContext) {
        InvocationContext result = new InvocationContext(() -> interceptionContext.proceed());
        result.set(javax.interceptor.InvocationContext.class, (Object)interceptionContext);
        return result;
    }

    private FaultToleranceStrategy<Object> prepareAsyncStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        AsyncTypesConversion.FromCompletionStage result = Invocation.invocation();
        result = new AsyncTypesConversion.ToCompletionStage(result, AsyncTypes.get(operation.getReturnType()));
        result = this.prepareComplectionStageChain(result, operation, point);
        result = new AsyncTypesConversion.FromCompletionStage(result, AsyncTypes.get(operation.getReturnType()));
        return result;
    }

    private <T> FaultToleranceStrategy<CompletionStage<T>> prepareComplectionStageChain(FaultToleranceStrategy<CompletionStage<T>> invocation, FaultToleranceOperation operation, InterceptionPoint point) {
        CompletionStageExecution result = invocation;
        result = new RequestScopeActivator<CompletionStage<T>>(result, this.requestContextController);
        if (operation.isThreadOffloadRequired()) {
            result = new CompletionStageExecution(result, (Executor)this.asyncExecutor);
        }
        if (operation.hasBulkhead()) {
            BulkheadConfig bulkheadConfig = operation.getBulkhead();
            Integer size = (Integer)bulkheadConfig.get("value");
            Integer queueSize = (Integer)bulkheadConfig.get("waitingTaskQueue");
            result = new CompletionStageBulkhead((FaultToleranceStrategy)result, "CompletionStage[" + point + "]", size.intValue(), queueSize.intValue());
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout(), "value", "unit");
            result = new CompletionStageTimeout((FaultToleranceStrategy)result, "Timeout[" + point + "]", timeoutMs, (TimeoutWatcher)new TimerTimeoutWatcher(this.timer));
        }
        if (operation.hasCircuitBreaker()) {
            CircuitBreakerConfig cbConfig = operation.getCircuitBreaker();
            long delayInMillis = this.getTimeInMs(cbConfig, "delay", "delayUnit");
            result = new CompletionStageCircuitBreaker((FaultToleranceStrategy)result, "CircuitBreaker[" + point + "]", this.getSetOfThrowables(cbConfig, "failOn"), this.getSetOfThrowables(cbConfig, "skipOn"), delayInMillis, ((Integer)cbConfig.get("requestVolumeThreshold")).intValue(), ((Double)cbConfig.get("failureRatio")).doubleValue(), ((Integer)cbConfig.get("successThreshold")).intValue(), (Stopwatch)new SystemStopwatch());
            String cbName = cbConfig.getCircuitBreakerName();
            if (cbName == null) {
                cbName = UUID.randomUUID().toString();
            }
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            RetryConfig retryConf = operation.getRetry();
            long maxDurationMs = this.getTimeInMs(retryConf, "maxDuration", "durationUnit");
            long delayMs = this.getTimeInMs(retryConf, "delay", "delayUnit");
            long jitterMs = this.getTimeInMs(retryConf, "jitter", "jitterDelayUnit");
            Jitter jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            result = new CompletionStageRetry((FaultToleranceStrategy)result, "Retry[" + point + "]", this.getSetOfThrowables(retryConf, "retryOn"), this.getSetOfThrowables(retryConf, "abortOn"), (long)((Integer)retryConf.get("maxRetries")).intValue(), maxDurationMs, () -> new TimerDelay((BackOff)new SimpleBackOff(delayMs, jitter), this.timer), (Stopwatch)new SystemStopwatch());
        }
        if (operation.hasFallback()) {
            FallbackConfig fallbackConf = operation.getFallback();
            result = new CompletionStageFallback((FaultToleranceStrategy)result, "Fallback[" + point + "]", this.prepareFallbackFunction(point, operation), this.getSetOfThrowables(fallbackConf, "applyOn"), this.getSetOfThrowables(fallbackConf, "skipOn"));
        }
        if (this.metricsProvider.isEnabled()) {
            result = new CompletionStageMetricsCollector((FaultToleranceStrategy)result, this.getMetricsRecorder(operation, point));
        }
        return result;
    }

    private <T> FaultToleranceStrategy<T> prepareSyncStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Invocation result = Invocation.invocation();
        if (operation.hasBulkhead()) {
            BulkheadConfig bulkheadConfig = operation.getBulkhead();
            result = new SemaphoreBulkhead((FaultToleranceStrategy)result, "Bulkhead[" + point + "]", ((Integer)bulkheadConfig.get("value")).intValue());
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout(), "value", "unit");
            result = new Timeout((FaultToleranceStrategy)result, "Timeout[" + point + "]", timeoutMs, (TimeoutWatcher)new TimerTimeoutWatcher(this.timer));
        }
        if (operation.hasCircuitBreaker()) {
            CircuitBreakerConfig cbConfig = operation.getCircuitBreaker();
            long delayInMillis = this.getTimeInMs(cbConfig, "delay", "delayUnit");
            result = new CircuitBreaker((FaultToleranceStrategy)result, "CircuitBreaker[" + point + "]", this.getSetOfThrowables(cbConfig, "failOn"), this.getSetOfThrowables(cbConfig, "skipOn"), delayInMillis, ((Integer)cbConfig.get("requestVolumeThreshold")).intValue(), ((Double)cbConfig.get("failureRatio")).doubleValue(), ((Integer)cbConfig.get("successThreshold")).intValue(), (Stopwatch)new SystemStopwatch());
            String cbName = cbConfig.getCircuitBreakerName();
            if (cbName == null) {
                cbName = UUID.randomUUID().toString();
            }
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            RetryConfig retryConf = operation.getRetry();
            long maxDurationMs = this.getTimeInMs(retryConf, "maxDuration", "durationUnit");
            long delayMs = this.getTimeInMs(retryConf, "delay", "delayUnit");
            long jitterMs = this.getTimeInMs(retryConf, "jitter", "jitterDelayUnit");
            Jitter jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            result = new Retry((FaultToleranceStrategy)result, "Retry[" + point + "]", this.getSetOfThrowables(retryConf, "retryOn"), this.getSetOfThrowables(retryConf, "abortOn"), (long)((Integer)retryConf.get("maxRetries")).intValue(), maxDurationMs, () -> new ThreadSleepDelay((BackOff)new SimpleBackOff(delayMs, jitter)), (Stopwatch)new SystemStopwatch());
        }
        if (operation.hasFallback()) {
            FallbackConfig fallbackConf = operation.getFallback();
            result = new Fallback((FaultToleranceStrategy)result, "Fallback[" + point + "]", this.prepareFallbackFunction(point, operation), this.getSetOfThrowables(fallbackConf, "applyOn"), this.getSetOfThrowables(fallbackConf, "skipOn"));
        }
        if (this.metricsProvider.isEnabled()) {
            result = new MetricsCollector((FaultToleranceStrategy)result, this.getMetricsRecorder(operation, point), false);
        }
        return result;
    }

    private <T> FaultToleranceStrategy<Future<T>> prepareFutureStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Object result = Invocation.invocation();
        result = new RequestScopeActivator(result, this.requestContextController);
        if (operation.hasBulkhead()) {
            BulkheadConfig bulkheadConfig = operation.getBulkhead();
            int size = (Integer)bulkheadConfig.get("value");
            int queueSize = (Integer)bulkheadConfig.get("waitingTaskQueue");
            result = new ThreadPoolBulkhead((FaultToleranceStrategy)result, "Bulkhead[" + point + "]", size, queueSize);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout(), "value", "unit");
            Timeout timeout = new Timeout((FaultToleranceStrategy)result, "Timeout[" + point + "]", timeoutMs, (TimeoutWatcher)new TimerTimeoutWatcher(this.timer));
            result = new AsyncTimeout(timeout, (Executor)this.asyncExecutor);
        }
        if (operation.hasCircuitBreaker()) {
            CircuitBreakerConfig cbConfig = operation.getCircuitBreaker();
            long delayInMillis = this.getTimeInMs(cbConfig, "delay", "delayUnit");
            result = new CircuitBreaker((FaultToleranceStrategy)result, "CircuitBreaker[" + point + "]", this.getSetOfThrowables(cbConfig, "failOn"), this.getSetOfThrowables(cbConfig, "skipOn"), delayInMillis, ((Integer)cbConfig.get("requestVolumeThreshold")).intValue(), ((Double)cbConfig.get("failureRatio")).doubleValue(), ((Integer)cbConfig.get("successThreshold")).intValue(), (Stopwatch)new SystemStopwatch());
            String cbName = cbConfig.getCircuitBreakerName();
            if (cbName == null) {
                cbName = UUID.randomUUID().toString();
            }
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            RetryConfig retryConf = operation.getRetry();
            long maxDurationMs = this.getTimeInMs(retryConf, "maxDuration", "durationUnit");
            long delayMs = this.getTimeInMs(retryConf, "delay", "delayUnit");
            long jitterMs = this.getTimeInMs(retryConf, "jitter", "jitterDelayUnit");
            Jitter jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            result = new Retry((FaultToleranceStrategy)result, "Retry[" + point + "]", this.getSetOfThrowables(retryConf, "retryOn"), this.getSetOfThrowables(retryConf, "abortOn"), (long)((Integer)retryConf.get("maxRetries")).intValue(), maxDurationMs, () -> new ThreadSleepDelay((BackOff)new SimpleBackOff(delayMs, jitter)), (Stopwatch)new SystemStopwatch());
        }
        if (operation.hasFallback()) {
            FallbackConfig fallbackConf = operation.getFallback();
            result = new Fallback((FaultToleranceStrategy)result, "Fallback[" + point + "]", this.prepareFallbackFunction(point, operation), this.getSetOfThrowables(fallbackConf, "applyOn"), this.getSetOfThrowables(fallbackConf, "skipOn"));
        }
        if (this.metricsProvider.isEnabled()) {
            result = new MetricsCollector((FaultToleranceStrategy)result, this.getMetricsRecorder(operation, point), true);
        }
        result = new FutureExecution((FaultToleranceStrategy)result, (Executor)this.asyncExecutor);
        return result;
    }

    private <V> FallbackFunction<V> prepareFallbackFunction(InterceptionPoint point, FaultToleranceOperation operation) {
        Method fallbackMethod = null;
        FallbackConfig fallbackConfig = operation.getFallback();
        Class fallback = (Class)fallbackConfig.get("value");
        String fallbackMethodName = (String)fallbackConfig.get("fallbackMethod");
        if (fallback.equals(Fallback.DEFAULT.class) && !"".equals(fallbackMethodName)) {
            try {
                Method method = point.method();
                fallbackMethod = SecurityActions.getDeclaredMethod(point.beanClass(), method.getDeclaringClass(), fallbackMethodName, method.getGenericParameterTypes());
                if (fallbackMethod == null) {
                    throw new FaultToleranceException("Could not obtain fallback method " + fallbackMethodName);
                }
                SecurityActions.setAccessible(fallbackMethod);
            }
            catch (PrivilegedActionException e) {
                throw new FaultToleranceException("Could not obtain fallback method", (Throwable)e);
            }
        }
        Class<?> returnType = operation.getReturnType();
        Method fallbackMethodFinal = fallbackMethod;
        if (fallbackMethod != null) {
            boolean isDefault = fallbackMethodFinal.isDefault();
            return ctx -> {
                javax.interceptor.InvocationContext interceptionContext = (javax.interceptor.InvocationContext)ctx.invocationContext.get(javax.interceptor.InvocationContext.class);
                ExecutionContextWithInvocationContext executionContext = new ExecutionContextWithInvocationContext(interceptionContext);
                try {
                    Object result = isDefault ? DefaultMethodFallbackProvider.getFallback(fallbackMethodFinal, executionContext) : fallbackMethodFinal.invoke(interceptionContext.getTarget(), interceptionContext.getParameters());
                    result = AsyncTypes.toCompletionStageIfRequired(result, returnType);
                    return result;
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = e.getCause();
                    }
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new FaultToleranceException("Error during fallback method invocation", e);
                }
            };
        }
        FallbackHandler fallbackHandler = this.fallbackHandlerProvider.get(operation);
        if (fallbackHandler != null) {
            return ctx -> {
                javax.interceptor.InvocationContext interceptionContext = (javax.interceptor.InvocationContext)ctx.invocationContext.get(javax.interceptor.InvocationContext.class);
                ExecutionContextWithInvocationContext executionContext = new ExecutionContextWithInvocationContext(interceptionContext);
                executionContext.setFailure(ctx.failure);
                Object result = fallbackHandler.handle((ExecutionContext)executionContext);
                result = AsyncTypes.toCompletionStageIfRequired(result, returnType);
                return result;
            };
        }
        throw new FaultToleranceException("Could not obtain fallback handler for " + point);
    }

    private long getTimeInMs(GenericConfig<?> config, String configKey, String unitConfigKey) {
        long time = (Long)config.get(configKey);
        ChronoUnit unit = (ChronoUnit)config.get(unitConfigKey);
        return Duration.of(time, unit).toMillis();
    }

    private SetOfThrowables getSetOfThrowables(GenericConfig<?> config, String configKey) {
        Class[] throwableClasses = (Class[])config.get(configKey);
        if (throwableClasses == null) {
            return SetOfThrowables.EMPTY;
        }
        return SetOfThrowables.create(Arrays.asList(throwableClasses));
    }

    private MetricsRecorder getMetricsRecorder(FaultToleranceOperation operation, InterceptionPoint point) {
        return this.cache.getMetrics(point, () -> this.metricsProvider.create(operation));
    }
}

