package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.Asynchronous;

/**
 * Automatically generated from the {@link AsynchronousConfig} config interface, do not modify.
 */
public final class AsynchronousConfigImpl implements AsynchronousConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Asynchronous instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    private AsynchronousConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.asynchronous;
        this.onMethod = method.annotationsPresentDirectly.contains(Asynchronous.class);
    }

    public static AsynchronousConfigImpl create(FaultToleranceMethod method) {
        if (method.asynchronous == null) {
            return null;
        }
        if (!Config.isEnabled(Asynchronous.class, method.method)) {
            return null;
        }
        return new AsynchronousConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Asynchronous.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "Asynchronous" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "Asynchronous" + "/" + key;
    }

    @Override
    public void materialize() {
    }
}
