package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * Automatically generated from the {@link FibonacciBackoffConfig} config interface, do not modify.
 */
public final class FibonacciBackoffConfigImpl implements FibonacciBackoffConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final FibonacciBackoff instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code FibonacciBackoff.maxDelay} annotation member; {@code null} if not looked up yet.
     */
    private Long _maxDelay;

    /**
     * Cached value of the {@code FibonacciBackoff.maxDelayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _maxDelayUnit;

    private FibonacciBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.fibonacciBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(FibonacciBackoff.class);
    }

    public static FibonacciBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.fibonacciBackoff == null) {
            return null;
        }
        if (!Config.isEnabled(FibonacciBackoff.class, method.method)) {
            return null;
        }
        return new FibonacciBackoffConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return FibonacciBackoff.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public long maxDelay() {
        if (_maxDelay == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _maxDelay = config.getOptionalValue(getConfigKeyForMethod("maxDelay"), long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _maxDelay = config.getOptionalValue(getConfigKeyForClass("maxDelay"), long.class).orElse(null);
            }
            if (_maxDelay == null) {
                // <annotation>/<parameter>
                _maxDelay = config.getOptionalValue("FibonacciBackoff" + "/" + "maxDelay", long.class).orElse(null);
            }
            if (_maxDelay == null) {
                // annotation value
                _maxDelay = instance.maxDelay();
            }
        }
        return _maxDelay;
    }

    @Override
    public ChronoUnit maxDelayUnit() {
        if (_maxDelayUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _maxDelayUnit = config.getOptionalValue(getConfigKeyForMethod("maxDelayUnit"), ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _maxDelayUnit = config.getOptionalValue(getConfigKeyForClass("maxDelayUnit"), ChronoUnit.class).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // <annotation>/<parameter>
                _maxDelayUnit = config.getOptionalValue("FibonacciBackoff" + "/" + "maxDelayUnit", ChronoUnit.class).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // annotation value
                _maxDelayUnit = instance.maxDelayUnit();
            }
        }
        return _maxDelayUnit;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "FibonacciBackoff" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "FibonacciBackoff" + "/" + key;
    }

    @Override
    public void materialize() {
        maxDelay();
        maxDelayUnit();
    }
}
