package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * Automatically generated from the {@link ApplyFaultToleranceConfig} config interface, do not modify.
 */
public final class ApplyFaultToleranceConfigImpl implements ApplyFaultToleranceConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final ApplyFaultTolerance instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code ApplyFaultTolerance.value} annotation member; {@code null} if not looked up yet.
     */
    private String _value;

    private ApplyFaultToleranceConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.applyFaultTolerance;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyFaultTolerance.class);
    }

    public static ApplyFaultToleranceConfigImpl create(FaultToleranceMethod method) {
        if (method.applyFaultTolerance == null) {
            return null;
        }
        if (!Config.isEnabled(ApplyFaultTolerance.class, method.method)) {
            return null;
        }
        return new ApplyFaultToleranceConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ApplyFaultTolerance.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public String value() {
        if (_value == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForMethod("value"), String.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                _value = config.getOptionalValue(getConfigKeyForClass("value"), String.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<parameter>
                _value = config.getOptionalValue("ApplyFaultTolerance" + "/" + "value", String.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "ApplyFaultTolerance" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "ApplyFaultTolerance" + "/" + key;
    }

    @Override
    public void materialize() {
        value();
    }
}
