/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.AsyncExecutorProvider;
import io.smallrye.faulttolerance.DefaultAsyncExecutorProvider;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.timer.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExecutorHolder {
    private final ExecutorService asyncExecutor;
    private final EventLoop eventLoop;
    private final Timer timer;
    private final boolean shouldShutdownAsyncExecutor;

    @Inject
    public ExecutorHolder(AsyncExecutorProvider asyncExecutorProvider) {
        this.asyncExecutor = asyncExecutorProvider.get();
        this.eventLoop = EventLoop.get();
        this.timer = new Timer((Executor)this.asyncExecutor);
        this.shouldShutdownAsyncExecutor = asyncExecutorProvider instanceof DefaultAsyncExecutorProvider;
    }

    @PreDestroy
    public void tearDown() {
        try {
            this.timer.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.shouldShutdownAsyncExecutor) {
            this.asyncExecutor.shutdownNow();
            try {
                this.asyncExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

