/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.RequestContextIntegration;
import io.smallrye.faulttolerance.SecurityActions;
import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.apiimpl.LazyFaultTolerance;
import io.smallrye.faulttolerance.core.async.CompletionStageExecution;
import io.smallrye.faulttolerance.core.async.FutureExecution;
import io.smallrye.faulttolerance.core.async.RememberEventLoop;
import io.smallrye.faulttolerance.core.bulkhead.CompletionStageThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.FutureThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.SemaphoreBulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.circuit.breaker.CompletionStageCircuitBreaker;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.fallback.AsyncFallbackFunction;
import io.smallrye.faulttolerance.core.fallback.CompletionStageFallback;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.AsyncSupportRegistry;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.NormalMethodInvoker;
import io.smallrye.faulttolerance.core.invocation.SpecialMethodInvoker;
import io.smallrye.faulttolerance.core.invocation.StrategyInvoker;
import io.smallrye.faulttolerance.core.metrics.CompletionStageMetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.CompletionStageRetry;
import io.smallrye.faulttolerance.core.retry.ConstantBackOff;
import io.smallrye.faulttolerance.core.retry.CustomBackOff;
import io.smallrye.faulttolerance.core.retry.ExponentialBackOff;
import io.smallrye.faulttolerance.core.retry.FibonacciBackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.AsyncTimeout;
import io.smallrye.faulttolerance.core.timeout.CompletionStageTimeout;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.timeout.TimerTimeoutWatcher;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.DirectExecutor;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.SetBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import io.smallrye.faulttolerance.internal.InterceptionInvoker;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.RequestScopeActivator;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.MetricsProvider;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.control.RequestContextController;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@Interceptor
@FaultToleranceBinding
@Priority(value=4010)
public class FaultToleranceInterceptor {
    private final Bean<?> interceptedBean;
    private final FaultToleranceOperationProvider operationProvider;
    private final StrategyCache cache;
    private final FallbackHandlerProvider fallbackHandlerProvider;
    private final MetricsProvider metricsProvider;
    private final ExecutorService asyncExecutor;
    private final EventLoop eventLoop;
    private final Timer timer;
    private final RequestContextController requestContextController;
    private final CircuitBreakerMaintenanceImpl cbMaintenance;
    private final SpecCompatibility specCompatibility;
    private final Instance<FaultTolerance<?>> configuredFaultTolerance;

    @Inject
    public FaultToleranceInterceptor(@Intercepted Bean<?> interceptedBean, FaultToleranceOperationProvider operationProvider, StrategyCache cache, FallbackHandlerProvider fallbackHandlerProvider, MetricsProvider metricsProvider, ExecutorHolder executorHolder, RequestContextIntegration requestContextIntegration, CircuitBreakerMaintenanceImpl cbMaintenance, SpecCompatibility specCompatibility, @Any Instance<FaultTolerance<?>> configuredFaultTolerance) {
        this.interceptedBean = interceptedBean;
        this.operationProvider = operationProvider;
        this.cache = cache;
        this.fallbackHandlerProvider = fallbackHandlerProvider;
        this.metricsProvider = metricsProvider;
        this.asyncExecutor = executorHolder.getAsyncExecutor();
        this.eventLoop = executorHolder.getEventLoop();
        this.timer = executorHolder.getTimer();
        this.requestContextController = requestContextIntegration.get();
        this.cbMaintenance = cbMaintenance;
        this.specCompatibility = specCompatibility;
        this.configuredFaultTolerance = configuredFaultTolerance;
    }

    @AroundInvoke
    public Object intercept(jakarta.interceptor.InvocationContext interceptionContext) throws Exception {
        Method method = interceptionContext.getMethod();
        Class beanClass = this.interceptedBean != null ? this.interceptedBean.getBeanClass() : method.getDeclaringClass();
        InterceptionPoint point = new InterceptionPoint(beanClass, interceptionContext.getMethod());
        FaultToleranceOperation operation = this.operationProvider.get(beanClass, method);
        if (operation.hasApplyFaultTolerance()) {
            return this.preconfiguredFlow(operation, interceptionContext);
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation)) {
            return this.asyncFlow(operation, interceptionContext, point);
        }
        if (this.specCompatibility.isOperationPseudoAsynchronous(operation)) {
            return this.futureFlow(operation, interceptionContext, point);
        }
        return this.syncFlow(operation, interceptionContext, point);
    }

    private Object preconfiguredFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext) throws Exception {
        AsyncSupport fromConfigured;
        String identifier = operation.getApplyFaultTolerance().value();
        Instance instance = this.configuredFaultTolerance.select(new Annotation[]{Identifier.Literal.of((String)identifier)});
        if (!instance.isResolvable()) {
            throw new FaultToleranceException("Can't resolve a bean of type " + FaultTolerance.class.getName() + " with qualifier @" + Identifier.class.getName() + "(\"" + identifier + "\")");
        }
        FaultTolerance faultTolerance = (FaultTolerance)instance.get();
        if (!(faultTolerance instanceof LazyFaultTolerance)) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' is not created by the FaultTolerance API, this is not supported");
        }
        Class asyncType = ((LazyFaultTolerance)faultTolerance).internalGetAsyncType();
        AsyncSupport forOperation = AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType());
        AsyncSupport asyncSupport = fromConfigured = asyncType == null ? null : AsyncSupportRegistry.get((Class[])new Class[0], (Class)asyncType);
        if (forOperation == null && fromConfigured == null) {
            return faultTolerance.call(() -> ((jakarta.interceptor.InvocationContext)interceptionContext).proceed());
        }
        if (forOperation == null) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to " + fromConfigured.mustDescription() + ", but the operation is synchronous: " + operation);
        }
        if (fromConfigured == null) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to be synchronous, but it " + forOperation.doesDescription() + ": " + operation);
        }
        if (!forOperation.getClass().equals(fromConfigured.getClass())) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to " + fromConfigured.mustDescription() + ", but it " + forOperation.doesDescription() + ": " + operation);
        }
        return faultTolerance.call(() -> ((jakarta.interceptor.InvocationContext)interceptionContext).proceed());
    }

    private <V, AT> AT asyncFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext, InterceptionPoint point) {
        AsyncSupport asyncSupport = AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType());
        if (asyncSupport == null) {
            throw new FaultToleranceException("Unknown async invocation: " + operation);
        }
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareAsyncStrategy(operation, point));
        InterceptionInvoker invoker = new InterceptionInvoker(interceptionContext);
        InvocationContext<CompletionStage> ctx = this.invocationContext(() -> asyncSupport.toCompletionStage(invoker), interceptionContext, operation);
        StrategyInvoker wrapper = new StrategyInvoker(interceptionContext.getParameters(), strategy, ctx);
        try {
            return (AT)asyncSupport.fromCompletionStage((Invoker)wrapper);
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow((Throwable)e);
        }
    }

    private <T> T syncFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareSyncStrategy(operation, point));
        InvocationContext<Object> ctx = this.invocationContext(() -> interceptionContext.proceed(), interceptionContext, operation);
        return (T)strategy.apply(ctx);
    }

    private <T> Future<T> futureFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareFutureStrategy(operation, point));
        InvocationContext<Future> ctx = this.invocationContext(() -> (Future)interceptionContext.proceed(), interceptionContext, operation);
        return (Future)strategy.apply(ctx);
    }

    private <T> InvocationContext<T> invocationContext(Callable<T> callable, jakarta.interceptor.InvocationContext interceptionContext, FaultToleranceOperation operation) {
        InvocationContext result = new InvocationContext(callable);
        result.set(jakarta.interceptor.InvocationContext.class, (Object)interceptionContext);
        if (operation.hasCircuitBreaker() && operation.hasCircuitBreakerName()) {
            result.registerEventHandler(CircuitBreakerEvents.StateTransition.class, this.cbMaintenance.stateTransitionEventHandler(operation.getCircuitBreakerName().value()));
        }
        return result;
    }

    private <T> FaultToleranceStrategy<CompletionStage<T>> prepareAsyncStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Object result = Invocation.invocation();
        result = new RequestScopeActivator(result, this.requestContextController);
        Object executor = operation.isThreadOffloadRequired() ? this.asyncExecutor : DirectExecutor.INSTANCE;
        result = new CompletionStageExecution((FaultToleranceStrategy)result, (Executor)executor);
        if (operation.hasBulkhead()) {
            int size = operation.getBulkhead().value();
            int queueSize = operation.getBulkhead().waitingTaskQueue();
            result = new CompletionStageThreadPoolBulkhead((FaultToleranceStrategy)result, point.toString(), size, queueSize);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout().value(), operation.getTimeout().unit());
            result = new CompletionStageTimeout((FaultToleranceStrategy)result, point.toString(), timeoutMs, (TimeoutWatcher)new TimerTimeoutWatcher(this.timer));
        }
        if (operation.hasCircuitBreaker()) {
            long delayInMillis = this.getTimeInMs(operation.getCircuitBreaker().delay(), operation.getCircuitBreaker().delayUnit());
            result = new CompletionStageCircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), delayInMillis, operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)new SystemStopwatch());
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            long maxDurationMs = this.getTimeInMs(operation.getRetry().maxDuration(), operation.getRetry().durationUnit());
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new CompletionStageRetry((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn()), (long)operation.getRetry().maxRetries(), maxDurationMs, () -> new TimerDelay((BackOff)backoff.get(), this.timer), (Stopwatch)new SystemStopwatch());
        }
        if (operation.hasFallback()) {
            result = new CompletionStageFallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            result = new CompletionStageMetricsCollector((FaultToleranceStrategy)result, this.getMetricsRecorder(operation, point));
        }
        if (!operation.isThreadOffloadRequired()) {
            result = new RememberEventLoop((FaultToleranceStrategy)result, this.eventLoop);
        }
        return result;
    }

    private <T> FaultToleranceStrategy<T> prepareSyncStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Invocation result = Invocation.invocation();
        if (operation.hasBulkhead()) {
            result = new SemaphoreBulkhead((FaultToleranceStrategy)result, point.toString(), operation.getBulkhead().value());
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout().value(), operation.getTimeout().unit());
            result = new Timeout((FaultToleranceStrategy)result, point.toString(), timeoutMs, (TimeoutWatcher)new TimerTimeoutWatcher(this.timer));
        }
        if (operation.hasCircuitBreaker()) {
            long delayInMillis = this.getTimeInMs(operation.getCircuitBreaker().delay(), operation.getCircuitBreaker().delayUnit());
            result = new CircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), delayInMillis, operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)new SystemStopwatch());
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            long maxDurationMs = this.getTimeInMs(operation.getRetry().maxDuration(), operation.getRetry().durationUnit());
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new Retry((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn()), (long)operation.getRetry().maxRetries(), maxDurationMs, () -> new ThreadSleepDelay((BackOff)backoff.get()), (Stopwatch)new SystemStopwatch());
        }
        if (operation.hasFallback()) {
            result = new Fallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            result = new MetricsCollector((FaultToleranceStrategy)result, this.getMetricsRecorder(operation, point), false);
        }
        return result;
    }

    private <T> FaultToleranceStrategy<Future<T>> prepareFutureStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Object result = Invocation.invocation();
        result = new RequestScopeActivator(result, this.requestContextController);
        if (operation.hasBulkhead()) {
            int size = operation.getBulkhead().value();
            int queueSize = operation.getBulkhead().waitingTaskQueue();
            result = new FutureThreadPoolBulkhead((FaultToleranceStrategy)result, point.toString(), size, queueSize);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout().value(), operation.getTimeout().unit());
            Timeout timeout = new Timeout((FaultToleranceStrategy)result, point.toString(), timeoutMs, (TimeoutWatcher)new TimerTimeoutWatcher(this.timer));
            result = new AsyncTimeout(timeout, (Executor)this.asyncExecutor);
        }
        if (operation.hasCircuitBreaker()) {
            long delayInMillis = this.getTimeInMs(operation.getCircuitBreaker().delay(), operation.getCircuitBreaker().delayUnit());
            result = new CircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), delayInMillis, operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)new SystemStopwatch());
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            long maxDurationMs = this.getTimeInMs(operation.getRetry().maxDuration(), operation.getRetry().durationUnit());
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new Retry((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn()), (long)operation.getRetry().maxRetries(), maxDurationMs, () -> new ThreadSleepDelay((BackOff)backoff.get()), (Stopwatch)new SystemStopwatch());
        }
        if (operation.hasFallback()) {
            result = new Fallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            result = new MetricsCollector((FaultToleranceStrategy)result, this.getMetricsRecorder(operation, point), true);
        }
        result = new FutureExecution((FaultToleranceStrategy)result, (Executor)this.asyncExecutor);
        return result;
    }

    private Supplier<BackOff> prepareRetryBackoff(FaultToleranceOperation operation) {
        Jitter jitter;
        long delayMs = this.getTimeInMs(operation.getRetry().delay(), operation.getRetry().delayUnit());
        long jitterMs = this.getTimeInMs(operation.getRetry().jitter(), operation.getRetry().jitterDelayUnit());
        Object object = jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
        if (operation.hasExponentialBackoff()) {
            int factor = operation.getExponentialBackoff().factor();
            long maxDelay = this.getTimeInMs(operation.getExponentialBackoff().maxDelay(), operation.getExponentialBackoff().maxDelayUnit());
            return () -> new ExponentialBackOff(delayMs, factor, jitter, maxDelay);
        }
        if (operation.hasFibonacciBackoff()) {
            long maxDelay = this.getTimeInMs(operation.getFibonacciBackoff().maxDelay(), operation.getFibonacciBackoff().maxDelayUnit());
            return () -> new FibonacciBackOff(delayMs, jitter, maxDelay);
        }
        if (operation.hasCustomBackoff()) {
            Class strategy = operation.getCustomBackoff().value();
            return () -> {
                CustomBackoffStrategy instance;
                try {
                    instance = (CustomBackoffStrategy)strategy.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw SneakyThrow.sneakyThrow((Throwable)e);
                }
                instance.init(delayMs);
                return new CustomBackOff(arg_0 -> ((CustomBackoffStrategy)instance).nextDelayInMillis(arg_0));
            };
        }
        return () -> new ConstantBackOff(delayMs, jitter);
    }

    private <V> FallbackFunction<V> prepareFallbackFunction(InterceptionPoint point, FaultToleranceOperation operation) {
        FallbackFunction fallbackFunction;
        Method fallbackMethod = null;
        Class fallback = operation.getFallback().value();
        String fallbackMethodName = operation.getFallback().fallbackMethod();
        if (fallback.equals(Fallback.DEFAULT.class) && !"".equals(fallbackMethodName)) {
            try {
                Method method = point.method();
                fallbackMethod = SecurityActions.getDeclaredMethod(point.beanClass(), method.getDeclaringClass(), fallbackMethodName, method.getGenericParameterTypes());
                if (fallbackMethod == null) {
                    throw new FaultToleranceException("Could not obtain fallback method " + fallbackMethodName);
                }
                SecurityActions.setAccessible(fallbackMethod);
            }
            catch (PrivilegedActionException e) {
                throw new FaultToleranceException("Could not obtain fallback method", (Throwable)e);
            }
        }
        AsyncSupport asyncSupport = AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType());
        Method fallbackMethodFinal = fallbackMethod;
        if (fallbackMethod != null) {
            boolean isDefault = fallbackMethodFinal.isDefault();
            fallbackFunction = ctx -> {
                jakarta.interceptor.InvocationContext interceptionContext = (jakarta.interceptor.InvocationContext)ctx.invocationContext.get(jakarta.interceptor.InvocationContext.class);
                try {
                    SpecialMethodInvoker invoker = isDefault ? new SpecialMethodInvoker(fallbackMethodFinal, interceptionContext.getTarget(), interceptionContext.getParameters()) : new NormalMethodInvoker(fallbackMethodFinal, interceptionContext.getTarget(), interceptionContext.getParameters());
                    return asyncSupport == null ? invoker.proceed() : asyncSupport.toCompletionStage((Invoker)invoker);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = e.getCause();
                    }
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new FaultToleranceException("Error during fallback method invocation", e);
                }
            };
        } else {
            FallbackHandler fallbackHandler = this.fallbackHandlerProvider.get(operation);
            if (fallbackHandler != null) {
                fallbackFunction = ctx -> {
                    jakarta.interceptor.InvocationContext interceptionContext = (jakarta.interceptor.InvocationContext)ctx.invocationContext.get(jakarta.interceptor.InvocationContext.class);
                    ExecutionContextWithInvocationContext executionContext = new ExecutionContextWithInvocationContext(interceptionContext);
                    executionContext.setFailure(ctx.failure);
                    Object result = fallbackHandler.handle((ExecutionContext)executionContext);
                    if (asyncSupport != null) {
                        result = asyncSupport.fallbackResultToCompletionStage(result);
                    }
                    return result;
                };
            } else {
                throw new FaultToleranceException("Could not obtain fallback handler for " + point);
            }
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation) && operation.isThreadOffloadRequired()) {
            fallbackFunction = new AsyncFallbackFunction(fallbackFunction, (Executor)this.asyncExecutor);
        }
        return fallbackFunction;
    }

    private long getTimeInMs(long time, ChronoUnit unit) {
        return Duration.of(time, unit).toMillis();
    }

    private ExceptionDecision createExceptionDecision(Class<? extends Throwable>[] consideredExpected, Class<? extends Throwable>[] consideredFailure) {
        return new SetBasedExceptionDecision(this.createSetOfThrowables(consideredFailure), this.createSetOfThrowables(consideredExpected), this.specCompatibility.inspectExceptionCauseChain());
    }

    private SetOfThrowables createSetOfThrowables(Class<? extends Throwable>[] throwableClasses) {
        if (throwableClasses == null) {
            return SetOfThrowables.EMPTY;
        }
        return SetOfThrowables.create(Arrays.asList(throwableClasses));
    }

    private MetricsRecorder getMetricsRecorder(FaultToleranceOperation operation, InterceptionPoint point) {
        return this.cache.getMetrics(point, () -> this.metricsProvider.create(operation));
    }
}

