package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.annotation.Annotation;

/**
 * Automatically generated from the {@link AsynchronousNonBlockingConfig} config interface, do not modify.
 */
public final class AsynchronousNonBlockingConfigImpl implements AsynchronousNonBlockingConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final AsynchronousNonBlocking instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    private AsynchronousNonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.asynchronousNonBlocking;
        this.onMethod = method.annotationsPresentDirectly.contains(AsynchronousNonBlocking.class);
    }

    public static AsynchronousNonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.asynchronousNonBlocking == null) {
            return null;
        }
        if (!Config.isEnabled(AsynchronousNonBlocking.class, method.method)) {
            return null;
        }
        return new AsynchronousNonBlockingConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return AsynchronousNonBlocking.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public void materialize() {
    }
}
