package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * Automatically generated from the {@link RetryWhenConfig} config interface, do not modify.
 */
public final class RetryWhenConfigImpl implements RetryWhenConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final RetryWhen instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code RetryWhen.result} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Predicate<Object>> _result;

    /**
     * Cached value of the {@code RetryWhen.exception} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Predicate<Throwable>> _exception;

    private RetryWhenConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.retryWhen;
        this.onMethod = method.annotationsPresentDirectly.contains(RetryWhen.class);
    }

    public static RetryWhenConfigImpl create(FaultToleranceMethod method) {
        if (method.retryWhen == null) {
            return null;
        }
        if (!Config.isEnabled(RetryWhen.class, method.method)) {
            return null;
        }
        return new RetryWhenConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return RetryWhen.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<? extends Predicate<Object>> result() {
        if (_result == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RetryWhen/result";
                _result = config.getOptionalValue(key, Class.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RetryWhen/result";
                _result = config.getOptionalValue(key, Class.class).orElse(null);
            }
            if (_result == null) {
                // <annotation>/<parameter>
                _result = config.getOptionalValue("RetryWhen/result", Class.class).orElse(null);
            }
            if (_result == null) {
                // annotation value
                _result = instance.result();
            }
        }
        return _result;
    }

    @Override
    public Class<? extends Predicate<Throwable>> exception() {
        if (_exception == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/RetryWhen/exception";
                _exception = config.getOptionalValue(key, Class.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/RetryWhen/exception";
                _exception = config.getOptionalValue(key, Class.class).orElse(null);
            }
            if (_exception == null) {
                // <annotation>/<parameter>
                _exception = config.getOptionalValue("RetryWhen/exception", Class.class).orElse(null);
            }
            if (_exception == null) {
                // annotation value
                _exception = instance.exception();
            }
        }
        return _exception;
    }

    @Override
    public void materialize() {
        result();
        exception();
    }
}
