/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.MicroProfileMetricsRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@Singleton
public class MicroProfileMetricsProvider
implements MetricsProvider {
    private final boolean metricsEnabled;
    private final MetricRegistry registry;
    private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

    @Inject
    MicroProfileMetricsProvider(@RegistryType(type=MetricRegistry.Type.BASE) Provider<MetricRegistry> registry, @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true") boolean metricsEnabled, ExecutorHolder executorHolder) {
        this.metricsEnabled = metricsEnabled;
        this.registry = (MetricRegistry)registry.get();
        Metadata metadata = Metadata.builder().withName("ft.timer.scheduled").withUnit("none").build();
        Timer timer = executorHolder.getTimer();
        this.registry.gauge(metadata, (Object)timer, Timer::countScheduledTasks, new Tag[]{new Tag("id", "" + timer.getId())});
    }

    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    public MetricsRecorder create(MeteredOperation operation) {
        if (this.metricsEnabled) {
            return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new MicroProfileMetricsRecorder(this.registry, operation));
        }
        return MetricsRecorder.NOOP;
    }
}

