/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.MicrometerRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class MicrometerProvider
implements MetricsProvider {
    private final boolean metricsEnabled;
    private final MeterRegistry registry;
    private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

    @Inject
    MicrometerProvider(Provider<MeterRegistry> registry, @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true") boolean metricsEnabled, ExecutorHolder executorHolder) {
        this.metricsEnabled = metricsEnabled;
        this.registry = (MeterRegistry)registry.get();
        Timer timer = executorHolder.getTimer();
        this.registry.gauge("ft.timer.scheduled", Collections.singletonList(Tag.of((String)"id", (String)("" + timer.getId()))), (Object)timer, Timer::countScheduledTasks);
    }

    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    public MetricsRecorder create(MeteredOperation operation) {
        if (this.metricsEnabled) {
            return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new MicrometerRecorder(this.registry, operation));
        }
        return MetricsRecorder.NOOP;
    }
}

