package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

/**
 * Automatically generated from the {@link FallbackConfig} config interface, do not modify.
 */
public final class FallbackConfigImpl implements FallbackConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Fallback instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code Fallback.value} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends FallbackHandler<?>> _value;

    /**
     * Cached value of the {@code Fallback.fallbackMethod} annotation member; {@code null} if not looked up yet.
     */
    private String _fallbackMethod;

    /**
     * Cached value of the {@code Fallback.applyOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _applyOn;

    /**
     * Cached value of the {@code Fallback.skipOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _skipOn;

    private FallbackConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.fallback;
        this.onMethod = method.annotationsPresentDirectly.contains(Fallback.class);
    }

    public static FallbackConfigImpl create(FaultToleranceMethod method) {
        if (method.fallback == null) {
            return null;
        }
        if (!Config.isEnabled(Fallback.class, method.method)) {
            return null;
        }
        return new FallbackConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Fallback.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<? extends FallbackHandler<?>> value() {
        if (_value == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Fallback/value";
                _value = config.getOptionalValue(key, Class.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Fallback/value";
                _value = config.getOptionalValue(key, Class.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<parameter>
                _value = config.getOptionalValue("Fallback/value", Class.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public String fallbackMethod() {
        if (_fallbackMethod == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Fallback/fallbackMethod";
                _fallbackMethod = config.getOptionalValue(key, String.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Fallback/fallbackMethod";
                _fallbackMethod = config.getOptionalValue(key, String.class).orElse(null);
            }
            if (_fallbackMethod == null) {
                // <annotation>/<parameter>
                _fallbackMethod = config.getOptionalValue("Fallback/fallbackMethod", String.class).orElse(null);
            }
            if (_fallbackMethod == null) {
                // annotation value
                _fallbackMethod = instance.fallbackMethod();
            }
        }
        return _fallbackMethod;
    }

    @Override
    public Class<? extends Throwable>[] applyOn() {
        if (_applyOn == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Fallback/applyOn";
                _applyOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Fallback/applyOn";
                _applyOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (_applyOn == null) {
                // <annotation>/<parameter>
                _applyOn = config.getOptionalValue("Fallback/applyOn", Class[].class).orElse(null);
            }
            if (_applyOn == null) {
                // annotation value
                _applyOn = instance.applyOn();
            }
        }
        return _applyOn;
    }

    @Override
    public Class<? extends Throwable>[] skipOn() {
        if (_skipOn == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Fallback/skipOn";
                _skipOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Fallback/skipOn";
                _skipOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (_skipOn == null) {
                // <annotation>/<parameter>
                _skipOn = config.getOptionalValue("Fallback/skipOn", Class[].class).orElse(null);
            }
            if (_skipOn == null) {
                // annotation value
                _skipOn = instance.skipOn();
            }
        }
        return _skipOn;
    }

    @Override
    public void materialize() {
        value();
        fallbackMethod();
        applyOn();
        skipOn();
    }
}
