/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.faulttolerance.BeforeRetryHandlerProvider;
import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.ExecutionContextImpl;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.RequestContextIntegration;
import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.api.AlwaysOnException;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.api.Guard;
import io.smallrye.faulttolerance.api.NeverOnResult;
import io.smallrye.faulttolerance.api.TypedGuard;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.FailureContext;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.apiimpl.AsyncInvocation;
import io.smallrye.faulttolerance.core.apiimpl.GuardImpl;
import io.smallrye.faulttolerance.core.apiimpl.LazyFaultTolerance;
import io.smallrye.faulttolerance.core.apiimpl.LazyGuard;
import io.smallrye.faulttolerance.core.apiimpl.LazyTypedGuard;
import io.smallrye.faulttolerance.core.apiimpl.TypedGuardImpl;
import io.smallrye.faulttolerance.core.async.FutureExecution;
import io.smallrye.faulttolerance.core.async.RememberEventLoop;
import io.smallrye.faulttolerance.core.async.ThreadOffload;
import io.smallrye.faulttolerance.core.async.ThreadOffloadEnabled;
import io.smallrye.faulttolerance.core.bulkhead.Bulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.fallback.ThreadOffloadFallbackFunction;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.AsyncSupportRegistry;
import io.smallrye.faulttolerance.core.invocation.ConstantInvoker;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.StrategyInvoker;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MeteredOperationName;
import io.smallrye.faulttolerance.core.metrics.MetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.rate.limit.RateLimit;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.ConstantBackOff;
import io.smallrye.faulttolerance.core.retry.CustomBackOff;
import io.smallrye.faulttolerance.core.retry.ExponentialBackOff;
import io.smallrye.faulttolerance.core.retry.FibonacciBackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.FutureTimeout;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.Durations;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.PredicateBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.PredicateBasedResultDecision;
import io.smallrye.faulttolerance.core.util.ResultDecision;
import io.smallrye.faulttolerance.core.util.SetBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import io.smallrye.faulttolerance.internal.BeforeRetryMethod;
import io.smallrye.faulttolerance.internal.FallbackMethod;
import io.smallrye.faulttolerance.internal.FallbackMethodCandidates;
import io.smallrye.faulttolerance.internal.InterceptionInvoker;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.RequestScopeActivator;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.CdiMeteredOperationImpl;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.control.RequestContextController;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@Interceptor
@FaultToleranceBinding
@Priority(value=4010)
public class FaultToleranceInterceptor {
    private final Bean<?> interceptedBean;
    private final FaultToleranceOperationProvider operationProvider;
    private final StrategyCache cache;
    private final FallbackHandlerProvider fallbackHandlerProvider;
    private final BeforeRetryHandlerProvider beforeRetryHandlerProvider;
    private final MetricsProvider metricsProvider;
    private final ExecutorService asyncExecutor;
    private final EventLoop eventLoop;
    private final Timer timer;
    private final RequestContextController requestContextController;
    private final CircuitBreakerMaintenanceImpl cbMaintenance;
    private final SpecCompatibility specCompatibility;
    private final Instance<FaultTolerance<?>> configuredFaultTolerance;
    private final Instance<Guard> configuredGuard;
    private final Instance<TypedGuard<?>> configuredTypedGuard;

    @Inject
    public FaultToleranceInterceptor(@Intercepted Bean<?> interceptedBean, FaultToleranceOperationProvider operationProvider, StrategyCache cache, FallbackHandlerProvider fallbackHandlerProvider, BeforeRetryHandlerProvider beforeRetryHandlerProvider, MetricsProvider metricsProvider, ExecutorHolder executorHolder, RequestContextIntegration requestContextIntegration, CircuitBreakerMaintenanceImpl cbMaintenance, SpecCompatibility specCompatibility, @Any Instance<FaultTolerance<?>> configuredFaultTolerance, @Any Instance<Guard> configuredGuard, @Any Instance<TypedGuard<?>> configuredTypedGuard) {
        this.interceptedBean = interceptedBean;
        this.operationProvider = operationProvider;
        this.cache = cache;
        this.fallbackHandlerProvider = fallbackHandlerProvider;
        this.beforeRetryHandlerProvider = beforeRetryHandlerProvider;
        this.metricsProvider = metricsProvider;
        this.asyncExecutor = executorHolder.getAsyncExecutor();
        this.eventLoop = executorHolder.getEventLoop();
        this.timer = executorHolder.getTimer();
        this.requestContextController = requestContextIntegration.get();
        this.cbMaintenance = cbMaintenance;
        this.specCompatibility = specCompatibility;
        this.configuredFaultTolerance = configuredFaultTolerance;
        this.configuredGuard = configuredGuard;
        this.configuredTypedGuard = configuredTypedGuard;
    }

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Throwable {
        Method method = invocationContext.getMethod();
        Class beanClass = this.interceptedBean != null ? this.interceptedBean.getBeanClass() : method.getDeclaringClass();
        InterceptionPoint point = new InterceptionPoint(beanClass, invocationContext.getMethod());
        FaultToleranceOperation operation = this.operationProvider.get(beanClass, method);
        if (operation.hasApplyFaultTolerance()) {
            return this.applyFaultToleranceFlow(operation, invocationContext);
        }
        if (operation.hasApplyGuard()) {
            return this.applyGuardFlow(operation, invocationContext, point);
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation)) {
            return this.asyncFlow(operation, invocationContext, point);
        }
        if (this.specCompatibility.isOperationPseudoAsynchronous(operation)) {
            return this.futureFlow(operation, invocationContext, point);
        }
        return this.syncFlow(operation, invocationContext, point);
    }

    private <V, T> T applyFaultToleranceFlow(FaultToleranceOperation operation, InvocationContext invocationContext) throws Exception {
        AsyncSupport fromConfigured;
        String identifier = operation.getApplyFaultTolerance().value();
        Instance instance = this.configuredFaultTolerance.select(new Annotation[]{Identifier.Literal.of((String)identifier)});
        if (!instance.isResolvable()) {
            throw new FaultToleranceException("Can't resolve a bean of type " + FaultTolerance.class.getName() + " with qualifier @" + Identifier.class.getName() + "(\"" + identifier + "\")");
        }
        FaultTolerance faultTolerance = (FaultTolerance)instance.get();
        if (!(faultTolerance instanceof LazyFaultTolerance)) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' is not created by the FaultTolerance API, this is not supported");
        }
        LazyFaultTolerance lazyFaultTolerance = (LazyFaultTolerance)faultTolerance;
        Class asyncType = lazyFaultTolerance.internalGetAsyncType();
        MeteredOperationName meteredOperationName = new MeteredOperationName(operation.getName());
        AsyncSupport forOperation = AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType());
        AsyncSupport asyncSupport = fromConfigured = asyncType == null ? null : AsyncSupportRegistry.get((Class[])new Class[0], (Class)asyncType);
        if (forOperation == null && fromConfigured == null) {
            return (T)lazyFaultTolerance.call(() -> ((InvocationContext)invocationContext).proceed(), meteredOperationName);
        }
        if (forOperation == null) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to " + fromConfigured.mustDescription() + ", but the operation is synchronous: " + String.valueOf(operation));
        }
        if (fromConfigured == null) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to be synchronous, but it " + forOperation.doesDescription() + ": " + String.valueOf(operation));
        }
        if (!forOperation.getClass().equals(fromConfigured.getClass())) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to " + fromConfigured.mustDescription() + ", but it " + forOperation.doesDescription() + ": " + String.valueOf(operation));
        }
        return (T)lazyFaultTolerance.call(() -> ((InvocationContext)invocationContext).proceed(), meteredOperationName);
    }

    private <V, T> T applyGuardFlow(FaultToleranceOperation operation, InvocationContext invocationContext, InterceptionPoint point) throws Exception {
        ExceptionDecision exceptionDecision;
        FallbackFunction fallbackFunction;
        String identifier = operation.getApplyGuard().value();
        Instance guardInstance = this.configuredGuard.select(new Annotation[]{Identifier.Literal.of((String)identifier)});
        Instance typedGuardInstance = this.configuredTypedGuard.select(new Annotation[]{Identifier.Literal.of((String)identifier)});
        if (!guardInstance.isResolvable() && !typedGuardInstance.isResolvable()) {
            throw new FaultToleranceException("Can't resolve a bean of type " + Guard.class.getName() + " or " + TypedGuard.class.getName() + " with qualifier @" + Identifier.class.getName() + "(\"" + identifier + "\")");
        }
        AsyncSupport asyncSupport = this.cache.getAsyncSupport(point, operation);
        AsyncInvocation asyncInvocation = asyncSupport != null ? new AsyncInvocation(asyncSupport, new InterceptionInvoker(invocationContext), invocationContext.getParameters()) : null;
        if (operation.hasFallback()) {
            fallbackFunction = this.cache.getFallbackFunction(point, () -> this.prepareFallbackFunction(point, operation));
            exceptionDecision = this.cache.getFallbackExceptionDecision(point, () -> this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        } else {
            fallbackFunction = null;
            exceptionDecision = null;
        }
        Boolean threadOffload = this.specCompatibility.isOperationTrulyAsynchronous(operation) ? Boolean.valueOf(operation.isThreadOffloadRequired()) : null;
        MeteredOperationName meteredOperationName = new MeteredOperationName(operation.getName());
        Consumer<FaultToleranceContext> contextModifier = ctx -> {
            ctx.set(InvocationContext.class, (Object)invocationContext);
            if (fallbackFunction != null) {
                ctx.set(FallbackFunction.class, (Object)fallbackFunction);
            }
            if (exceptionDecision != null) {
                ctx.set(ExceptionDecision.class, (Object)exceptionDecision);
            }
            if (threadOffload != null) {
                ctx.set(ThreadOffloadEnabled.class, (Object)new ThreadOffloadEnabled(threadOffload.booleanValue()));
            }
            ctx.set(MeteredOperationName.class, (Object)meteredOperationName);
        };
        if (guardInstance.isResolvable()) {
            Guard guard = (Guard)guardInstance.get();
            if (!(guard instanceof LazyGuard)) {
                throw new FaultToleranceException("Configured Guard '" + identifier + "' is not created by the Guard API, this is not supported");
            }
            GuardImpl guardImpl = ((LazyGuard)guard).instance();
            return (T)guardImpl.guard(() -> invocationContext.proceed(), asyncInvocation, contextModifier);
        }
        TypedGuard guard = (TypedGuard)typedGuardInstance.get();
        if (!(guard instanceof LazyTypedGuard)) {
            throw new FaultToleranceException("Configured TypedGuard '" + identifier + "' is not created by the TypedGuard API, this is not supported");
        }
        TypedGuardImpl guardImpl = ((LazyTypedGuard)guard).instance();
        return (T)guardImpl.guard(() -> invocationContext.proceed(), asyncInvocation, contextModifier);
    }

    private <V, AT> AT asyncFlow(FaultToleranceOperation operation, InvocationContext invocationContext, InterceptionPoint point) {
        AsyncSupport asyncSupport = this.cache.getAsyncSupport(point, operation);
        if (asyncSupport == null) {
            throw new FaultToleranceException("Unknown async invocation: " + String.valueOf(operation));
        }
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareStrategy(operation, point));
        InterceptionInvoker invoker = new InterceptionInvoker(invocationContext);
        FaultToleranceContext ctx = this.faultToleranceContext(() -> asyncSupport.toFuture(invoker), invocationContext, operation);
        StrategyInvoker wrapper = new StrategyInvoker(invocationContext.getParameters(), strategy, ctx);
        return (AT)asyncSupport.fromFuture((Invoker)wrapper);
    }

    private <V> V syncFlow(FaultToleranceOperation operation, InvocationContext invocationContext, InterceptionPoint point) throws Throwable {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareStrategy(operation, point));
        FaultToleranceContext ctx = this.faultToleranceContext(() -> Future.from(() -> invocationContext.proceed()), invocationContext, operation);
        return (V)strategy.apply(ctx).awaitBlocking();
    }

    private <V> java.util.concurrent.Future<V> futureFlow(FaultToleranceOperation operation, InvocationContext invocationContext, InterceptionPoint point) throws Throwable {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareFutureStrategy(operation, point));
        FaultToleranceContext ctx = this.faultToleranceContext(() -> Future.from(() -> (java.util.concurrent.Future)invocationContext.proceed()), invocationContext, operation);
        try {
            return (java.util.concurrent.Future)strategy.apply(ctx).awaitBlocking();
        }
        catch (Throwable e) {
            throw new ExecutionException(e);
        }
    }

    private <T> FaultToleranceContext<T> faultToleranceContext(Supplier<Future<T>> callable, InvocationContext invocationContext, FaultToleranceOperation operation) {
        FaultToleranceContext result = new FaultToleranceContext(callable, this.specCompatibility.isOperationTrulyAsynchronous(operation));
        result.set(InvocationContext.class, (Object)invocationContext);
        if (operation.hasCircuitBreaker() && operation.hasCircuitBreakerName()) {
            result.registerEventHandler(CircuitBreakerEvents.StateTransition.class, this.cbMaintenance.stateTransitionEventHandler(operation.getCircuitBreakerName().value()));
        }
        return result;
    }

    private <T> FaultToleranceStrategy<T> prepareStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Object result = Invocation.invocation();
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation)) {
            result = new RequestScopeActivator(result, this.requestContextController);
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation)) {
            result = new ThreadOffload((FaultToleranceStrategy)result, (Executor)this.asyncExecutor, operation.isThreadOffloadRequired());
        }
        if (operation.hasBulkhead()) {
            result = new Bulkhead((FaultToleranceStrategy)result, point.toString(), operation.getBulkhead().value(), operation.getBulkhead().waitingTaskQueue(), false);
        }
        if (operation.hasTimeout()) {
            result = new Timeout((FaultToleranceStrategy)result, point.toString(), Durations.timeInMillis((long)operation.getTimeout().value(), (ChronoUnit)operation.getTimeout().unit()), this.timer);
        }
        if (operation.hasRateLimit()) {
            result = new RateLimit((FaultToleranceStrategy)result, point.toString(), operation.getRateLimit().value(), Durations.timeInMillis((long)operation.getRateLimit().window(), (ChronoUnit)operation.getRateLimit().windowUnit()), Durations.timeInMillis((long)operation.getRateLimit().minSpacing(), (ChronoUnit)operation.getRateLimit().minSpacingUnit()), operation.getRateLimit().type(), (Stopwatch)SystemStopwatch.INSTANCE);
        }
        if (operation.hasCircuitBreaker()) {
            result = new CircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), Durations.timeInMillis((long)operation.getCircuitBreaker().delay(), (ChronoUnit)operation.getCircuitBreaker().delayUnit()), operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, this.timer);
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new Retry((FaultToleranceStrategy)result, point.toString(), this.createResultDecision(operation.hasRetryWhen() ? operation.getRetryWhen().result() : null), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn(), operation.hasRetryWhen() ? operation.getRetryWhen().exception() : null), (long)operation.getRetry().maxRetries(), Durations.timeInMillis((long)operation.getRetry().maxDuration(), (ChronoUnit)operation.getRetry().durationUnit()), () -> new ThreadSleepDelay((BackOff)backoff.get()), () -> new TimerDelay((BackOff)backoff.get(), this.timer), (Stopwatch)SystemStopwatch.INSTANCE, operation.hasBeforeRetry() ? this.prepareBeforeRetryFunction(point, operation) : null);
        }
        if (operation.hasFallback()) {
            result = new Fallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            CdiMeteredOperationImpl meteredOperation = new CdiMeteredOperationImpl(operation, point, this.specCompatibility);
            result = new MetricsCollector((FaultToleranceStrategy)result, this.metricsProvider.create((MeteredOperation)meteredOperation), (MeteredOperation)meteredOperation);
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation)) {
            result = new RememberEventLoop((FaultToleranceStrategy)result, this.eventLoop, operation.isThreadOffloadRequired());
        }
        return result;
    }

    private <T> FaultToleranceStrategy<java.util.concurrent.Future<T>> prepareFutureStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Object result = Invocation.invocation();
        result = new RequestScopeActivator(result, this.requestContextController);
        if (operation.hasBulkhead()) {
            result = new Bulkhead((FaultToleranceStrategy)result, point.toString(), operation.getBulkhead().value(), operation.getBulkhead().waitingTaskQueue(), true);
        }
        if (operation.hasTimeout()) {
            Timeout timeout = new Timeout((FaultToleranceStrategy)result, point.toString(), Durations.timeInMillis((long)operation.getTimeout().value(), (ChronoUnit)operation.getTimeout().unit()), this.timer);
            result = new FutureTimeout(timeout, (Executor)this.asyncExecutor);
        }
        if (operation.hasRateLimit()) {
            result = new RateLimit((FaultToleranceStrategy)result, point.toString(), operation.getRateLimit().value(), Durations.timeInMillis((long)operation.getRateLimit().window(), (ChronoUnit)operation.getRateLimit().windowUnit()), Durations.timeInMillis((long)operation.getRateLimit().minSpacing(), (ChronoUnit)operation.getRateLimit().minSpacingUnit()), operation.getRateLimit().type(), (Stopwatch)SystemStopwatch.INSTANCE);
        }
        if (operation.hasCircuitBreaker()) {
            result = new CircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), Durations.timeInMillis((long)operation.getCircuitBreaker().delay(), (ChronoUnit)operation.getCircuitBreaker().delayUnit()), operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, this.timer);
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new Retry((FaultToleranceStrategy)result, point.toString(), this.createResultDecision(operation.hasRetryWhen() ? operation.getRetryWhen().result() : null), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn(), operation.hasRetryWhen() ? operation.getRetryWhen().exception() : null), (long)operation.getRetry().maxRetries(), Durations.timeInMillis((long)operation.getRetry().maxDuration(), (ChronoUnit)operation.getRetry().durationUnit()), () -> new ThreadSleepDelay((BackOff)backoff.get()), () -> new TimerDelay((BackOff)backoff.get(), this.timer), (Stopwatch)SystemStopwatch.INSTANCE, operation.hasBeforeRetry() ? this.prepareBeforeRetryFunction(point, operation) : null);
        }
        if (operation.hasFallback()) {
            result = new Fallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            CdiMeteredOperationImpl meteredOperation = new CdiMeteredOperationImpl(operation, point, this.specCompatibility);
            result = new MetricsCollector((FaultToleranceStrategy)result, this.metricsProvider.create((MeteredOperation)meteredOperation), (MeteredOperation)meteredOperation);
        }
        result = new FutureExecution((FaultToleranceStrategy)result, (Executor)this.asyncExecutor);
        return result;
    }

    private Supplier<BackOff> prepareRetryBackoff(FaultToleranceOperation operation) {
        Jitter jitter;
        long delayMs = Durations.timeInMillis((long)operation.getRetry().delay(), (ChronoUnit)operation.getRetry().delayUnit());
        long jitterMs = Durations.timeInMillis((long)operation.getRetry().jitter(), (ChronoUnit)operation.getRetry().jitterDelayUnit());
        Object object = jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
        if (operation.hasExponentialBackoff()) {
            int factor = operation.getExponentialBackoff().factor();
            long maxDelay = Durations.timeInMillis((long)operation.getExponentialBackoff().maxDelay(), (ChronoUnit)operation.getExponentialBackoff().maxDelayUnit());
            return () -> new ExponentialBackOff(delayMs, factor, jitter, maxDelay);
        }
        if (operation.hasFibonacciBackoff()) {
            long maxDelay = Durations.timeInMillis((long)operation.getFibonacciBackoff().maxDelay(), (ChronoUnit)operation.getFibonacciBackoff().maxDelayUnit());
            return () -> new FibonacciBackOff(delayMs, jitter, maxDelay);
        }
        if (operation.hasCustomBackoff()) {
            Class strategy = operation.getCustomBackoff().value();
            return () -> {
                CustomBackoffStrategy instance;
                try {
                    instance = (CustomBackoffStrategy)strategy.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw SneakyThrow.sneakyThrow((Throwable)e);
                }
                instance.init(delayMs);
                return new CustomBackOff(arg_0 -> ((CustomBackoffStrategy)instance).nextDelayInMillis(arg_0));
            };
        }
        return () -> new ConstantBackOff(delayMs, jitter);
    }

    private <V, T> FallbackFunction<V> prepareFallbackFunction(InterceptionPoint point, FaultToleranceOperation operation) {
        FallbackFunction fallbackFunction;
        FallbackMethodCandidates candidates;
        AsyncSupport asyncSupport = this.cache.getAsyncSupport(point, operation);
        String fallbackMethodName = operation.getFallback().fallbackMethod();
        FallbackMethodCandidates fallbackMethodCandidates = candidates = !"".equals(fallbackMethodName) ? this.cache.getFallbackMethodCandidates(point, operation) : null;
        if (candidates != null) {
            fallbackFunction = ctx -> {
                FallbackMethod fallbackMethod = candidates.select(ctx.failure.getClass());
                if (fallbackMethod == null) {
                    return Future.ofError((Throwable)ctx.failure);
                }
                try {
                    Invoker invoker = fallbackMethod.createInvoker((FailureContext)ctx);
                    return asyncSupport == null ? Future.of((Object)invoker.proceed()) : asyncSupport.toFuture(invoker);
                }
                catch (InvocationTargetException e) {
                    return Future.ofError((Throwable)e.getCause());
                }
                catch (Exception e) {
                    return Future.ofError((Throwable)new FaultToleranceException("Error during fallback method invocation", (Throwable)e));
                }
            };
        } else {
            FallbackHandler fallbackHandler = this.fallbackHandlerProvider.get(operation);
            if (fallbackHandler != null) {
                fallbackFunction = ctx -> {
                    ExecutionContextImpl executionContext = new ExecutionContextImpl((InvocationContext)ctx.context.get(InvocationContext.class), ctx.failure);
                    try {
                        Object result = fallbackHandler.handle((ExecutionContext)executionContext);
                        return asyncSupport == null ? Future.of((Object)result) : asyncSupport.toFuture(ConstantInvoker.of((Object)result));
                    }
                    catch (Exception e) {
                        return Future.ofError((Throwable)e);
                    }
                };
            } else {
                throw new FaultToleranceException("Could not obtain fallback handler for " + String.valueOf(point));
            }
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation) && operation.isThreadOffloadRequired()) {
            fallbackFunction = new ThreadOffloadFallbackFunction((Function)fallbackFunction, (Executor)this.asyncExecutor);
        }
        return fallbackFunction;
    }

    private Consumer<FailureContext> prepareBeforeRetryFunction(InterceptionPoint point, FaultToleranceOperation operation) {
        Consumer<FailureContext> beforeRetryFunction;
        BeforeRetryMethod method;
        String methodName = operation.getBeforeRetry().methodName();
        BeforeRetryMethod beforeRetryMethod = method = !"".equals(methodName) ? this.cache.getBeforeRetryMethod(point, operation) : null;
        if (method != null) {
            beforeRetryFunction = ctx -> {
                try {
                    method.createInvoker((FailureContext)ctx).proceed();
                }
                catch (InvocationTargetException e) {
                    throw SneakyThrow.sneakyThrow((Throwable)e.getCause());
                }
                catch (Throwable e) {
                    throw new FaultToleranceException("Error during before retry method invocation", e);
                }
            };
        } else {
            BeforeRetryHandler beforeRetryHandler = this.beforeRetryHandlerProvider.get(operation);
            if (beforeRetryHandler != null) {
                beforeRetryFunction = ctx -> {
                    ExecutionContextImpl executionContext = new ExecutionContextImpl((InvocationContext)ctx.context.get(InvocationContext.class), ctx.failure);
                    beforeRetryHandler.handle((ExecutionContext)executionContext);
                };
            } else {
                throw new FaultToleranceException("Could not obtain before retry handler for " + String.valueOf(point));
            }
        }
        return beforeRetryFunction;
    }

    private ResultDecision createResultDecision(Class<? extends Predicate<Object>> whenResult) {
        if (whenResult != null && whenResult != NeverOnResult.class) {
            Predicate<Object> predicate;
            try {
                predicate = whenResult.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw SneakyThrow.sneakyThrow((Throwable)e);
            }
            return new PredicateBasedResultDecision(predicate.negate());
        }
        return ResultDecision.ALWAYS_EXPECTED;
    }

    private ExceptionDecision createExceptionDecision(Class<? extends Throwable>[] consideredExpected, Class<? extends Throwable>[] consideredFailure) {
        return new SetBasedExceptionDecision(this.createSetOfThrowables(consideredFailure), this.createSetOfThrowables(consideredExpected), this.specCompatibility.inspectExceptionCauseChain());
    }

    private ExceptionDecision createExceptionDecision(Class<? extends Throwable>[] consideredExpected, Class<? extends Throwable>[] consideredFailure, Class<? extends Predicate<Throwable>> whenException) {
        if (whenException != null && whenException != AlwaysOnException.class) {
            Predicate<Throwable> predicate;
            try {
                predicate = whenException.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw SneakyThrow.sneakyThrow((Throwable)e);
            }
            return new PredicateBasedExceptionDecision(predicate.negate());
        }
        return new SetBasedExceptionDecision(this.createSetOfThrowables(consideredFailure), this.createSetOfThrowables(consideredExpected), this.specCompatibility.inspectExceptionCauseChain());
    }

    private SetOfThrowables createSetOfThrowables(Class<? extends Throwable>[] throwableClasses) {
        if (throwableClasses == null || throwableClasses.length == 0) {
            return SetOfThrowables.EMPTY;
        }
        return SetOfThrowables.create(Arrays.asList(throwableClasses));
    }
}

