/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.ConfigUtil;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Bulkhead;

public final class BulkheadConfigImpl
implements BulkheadConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Bulkhead instance;
    private final boolean onMethod;
    private Integer _value;
    private Integer _waitingTaskQueue;

    private BulkheadConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.bulkhead;
        this.onMethod = method.annotationsPresentDirectly.contains(Bulkhead.class);
    }

    public static BulkheadConfigImpl create(FaultToleranceMethod method) {
        if (method.bulkhead == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(Bulkhead.class, method.method)) {
            return null;
        }
        return new BulkheadConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Bulkhead.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int value() {
        if (this._value == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Bulkhead.class, "value", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Bulkhead.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Bulkhead.class, "value", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Bulkhead.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._value == null) {
                newKey = ConfigUtil.newKey(Bulkhead.class, "value");
                oldKey = ConfigUtil.oldKey(Bulkhead.class, "value");
                this._value = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public int waitingTaskQueue() {
        if (this._waitingTaskQueue == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(Bulkhead.class, "waitingTaskQueue", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(Bulkhead.class, "waitingTaskQueue", this.method.declaringClass, this.method.name);
                this._waitingTaskQueue = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(Bulkhead.class, "waitingTaskQueue", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(Bulkhead.class, "waitingTaskQueue", this.method.declaringClass);
                this._waitingTaskQueue = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._waitingTaskQueue == null) {
                newKey = ConfigUtil.newKey(Bulkhead.class, "waitingTaskQueue");
                oldKey = ConfigUtil.oldKey(Bulkhead.class, "waitingTaskQueue");
                this._waitingTaskQueue = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._waitingTaskQueue == null) {
                this._waitingTaskQueue = this.instance.waitingTaskQueue();
            }
        }
        return this._waitingTaskQueue;
    }

    public void materialize() {
        this.value();
        this.waitingTaskQueue();
    }
}

