/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import io.smallrye.faulttolerance.config.ConfigUtil;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;

public final class CircuitBreakerConfigImpl
implements CircuitBreakerConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final CircuitBreaker instance;
    private final boolean onMethod;
    private Class<? extends Throwable>[] _failOn;
    private Class<? extends Throwable>[] _skipOn;
    private Long _delay;
    private ChronoUnit _delayUnit;
    private Integer _requestVolumeThreshold;
    private Double _failureRatio;
    private Integer _successThreshold;

    private CircuitBreakerConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.circuitBreaker;
        this.onMethod = method.annotationsPresentDirectly.contains(CircuitBreaker.class);
    }

    public static CircuitBreakerConfigImpl create(FaultToleranceMethod method) {
        if (method.circuitBreaker == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(CircuitBreaker.class, method.method)) {
            return null;
        }
        return new CircuitBreakerConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return CircuitBreaker.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<? extends Throwable>[] failOn() {
        if (this._failOn == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "failOn", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "failOn", this.method.declaringClass, this.method.name);
                this._failOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "failOn", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "failOn", this.method.declaringClass);
                this._failOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._failOn == null) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "failOn");
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "failOn");
                this._failOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._failOn == null) {
                this._failOn = this.instance.failOn();
            }
        }
        return this._failOn;
    }

    public Class<? extends Throwable>[] skipOn() {
        if (this._skipOn == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "skipOn", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "skipOn", this.method.declaringClass, this.method.name);
                this._skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "skipOn", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "skipOn", this.method.declaringClass);
                this._skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._skipOn == null) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "skipOn");
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "skipOn");
                this._skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = this.instance.skipOn();
            }
        }
        return this._skipOn;
    }

    public long delay() {
        if (this._delay == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "delay", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "delay", this.method.declaringClass, this.method.name);
                this._delay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "delay", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "delay", this.method.declaringClass);
                this._delay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._delay == null) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "delay");
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "delay");
                this._delay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._delay == null) {
                this._delay = this.instance.delay();
            }
        }
        return this._delay;
    }

    public ChronoUnit delayUnit() {
        if (this._delayUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "delayUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "delayUnit", this.method.declaringClass, this.method.name);
                this._delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "delayUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "delayUnit", this.method.declaringClass);
                this._delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._delayUnit == null) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "delayUnit");
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "delayUnit");
                this._delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = this.instance.delayUnit();
            }
        }
        return this._delayUnit;
    }

    public int requestVolumeThreshold() {
        if (this._requestVolumeThreshold == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "requestVolumeThreshold", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "requestVolumeThreshold", this.method.declaringClass, this.method.name);
                this._requestVolumeThreshold = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "requestVolumeThreshold", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "requestVolumeThreshold", this.method.declaringClass);
                this._requestVolumeThreshold = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._requestVolumeThreshold == null) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "requestVolumeThreshold");
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "requestVolumeThreshold");
                this._requestVolumeThreshold = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._requestVolumeThreshold == null) {
                this._requestVolumeThreshold = this.instance.requestVolumeThreshold();
            }
        }
        return this._requestVolumeThreshold;
    }

    public double failureRatio() {
        if (this._failureRatio == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "failureRatio", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "failureRatio", this.method.declaringClass, this.method.name);
                this._failureRatio = config.getOptionalValue(newKey, Double.TYPE).or(() -> config.getOptionalValue(oldKey, Double.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "failureRatio", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "failureRatio", this.method.declaringClass);
                this._failureRatio = config.getOptionalValue(newKey, Double.TYPE).or(() -> config.getOptionalValue(oldKey, Double.TYPE)).orElse(null);
            }
            if (this._failureRatio == null) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "failureRatio");
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "failureRatio");
                this._failureRatio = config.getOptionalValue(newKey, Double.TYPE).or(() -> config.getOptionalValue(oldKey, Double.TYPE)).orElse(null);
            }
            if (this._failureRatio == null) {
                this._failureRatio = this.instance.failureRatio();
            }
        }
        return this._failureRatio;
    }

    public int successThreshold() {
        if (this._successThreshold == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "successThreshold", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "successThreshold", this.method.declaringClass, this.method.name);
                this._successThreshold = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "successThreshold", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "successThreshold", this.method.declaringClass);
                this._successThreshold = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._successThreshold == null) {
                newKey = ConfigUtil.newKey(CircuitBreaker.class, "successThreshold");
                oldKey = ConfigUtil.oldKey(CircuitBreaker.class, "successThreshold");
                this._successThreshold = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._successThreshold == null) {
                this._successThreshold = this.instance.successThreshold();
            }
        }
        return this._successThreshold;
    }

    public void materialize() {
        this.failOn();
        this.skipOn();
        this.delay();
        this.delayUnit();
        this.requestVolumeThreshold();
        this.failureRatio();
        this.successThreshold();
    }
}

