/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.BeforeRetryConfig;
import io.smallrye.faulttolerance.config.ConfigUtil;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class BeforeRetryConfigImpl
implements BeforeRetryConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final BeforeRetry instance;
    private final boolean onMethod;
    private Class<? extends BeforeRetryHandler> _value;
    private String _methodName;

    private BeforeRetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.beforeRetry;
        this.onMethod = method.annotationsPresentDirectly.contains(BeforeRetry.class);
    }

    public static BeforeRetryConfigImpl create(FaultToleranceMethod method) {
        if (method.beforeRetry == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(BeforeRetry.class, method.method)) {
            return null;
        }
        return new BeforeRetryConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return BeforeRetry.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<? extends BeforeRetryHandler> value() {
        if (this._value == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(BeforeRetry.class, "value", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(BeforeRetry.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(BeforeRetry.class, "value", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(BeforeRetry.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._value == null) {
                newKey = ConfigUtil.newKey(BeforeRetry.class, "value");
                oldKey = ConfigUtil.oldKey(BeforeRetry.class, "value");
                this._value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public String methodName() {
        if (this._methodName == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(BeforeRetry.class, "methodName", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(BeforeRetry.class, "methodName", this.method.declaringClass, this.method.name);
                this._methodName = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(BeforeRetry.class, "methodName", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(BeforeRetry.class, "methodName", this.method.declaringClass);
                this._methodName = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (this._methodName == null) {
                newKey = ConfigUtil.newKey(BeforeRetry.class, "methodName");
                oldKey = ConfigUtil.oldKey(BeforeRetry.class, "methodName");
                this._methodName = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (this._methodName == null) {
                this._methodName = this.instance.methodName();
            }
        }
        return this._methodName;
    }

    public void materialize() {
        this.value();
        this.methodName();
    }
}

