/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.RateLimitConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class RateLimitConfigImpl
implements RateLimitConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final RateLimit instance;
    private final boolean onMethod;
    private Integer _value;
    private Long _window;
    private ChronoUnit _windowUnit;
    private Long _minSpacing;
    private ChronoUnit _minSpacingUnit;
    private RateLimitType _type;

    private RateLimitConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.rateLimit;
        this.onMethod = method.annotationsPresentDirectly.contains(RateLimit.class);
    }

    public static RateLimitConfigImpl create(FaultToleranceMethod method) {
        if (method.rateLimit == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(RateLimit.class, method.method)) {
            return null;
        }
        return new RateLimitConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return RateLimit.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int value() {
        if (this._value == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RateLimit.class, "value", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RateLimit.class, "value", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._value == null) {
                newKey = ConfigUtil.newKey(RateLimit.class, "value");
                oldKey = ConfigUtil.oldKey(RateLimit.class, "value");
                this._value = config.getOptionalValue(newKey, Integer.TYPE).or(() -> config.getOptionalValue(oldKey, Integer.TYPE)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public long window() {
        if (this._window == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RateLimit.class, "window", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "window", this.method.declaringClass, this.method.name);
                this._window = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RateLimit.class, "window", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "window", this.method.declaringClass);
                this._window = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._window == null) {
                newKey = ConfigUtil.newKey(RateLimit.class, "window");
                oldKey = ConfigUtil.oldKey(RateLimit.class, "window");
                this._window = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._window == null) {
                this._window = this.instance.window();
            }
        }
        return this._window;
    }

    public ChronoUnit windowUnit() {
        if (this._windowUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RateLimit.class, "windowUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "windowUnit", this.method.declaringClass, this.method.name);
                this._windowUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RateLimit.class, "windowUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "windowUnit", this.method.declaringClass);
                this._windowUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._windowUnit == null) {
                newKey = ConfigUtil.newKey(RateLimit.class, "windowUnit");
                oldKey = ConfigUtil.oldKey(RateLimit.class, "windowUnit");
                this._windowUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._windowUnit == null) {
                this._windowUnit = this.instance.windowUnit();
            }
        }
        return this._windowUnit;
    }

    public long minSpacing() {
        if (this._minSpacing == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RateLimit.class, "minSpacing", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "minSpacing", this.method.declaringClass, this.method.name);
                this._minSpacing = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RateLimit.class, "minSpacing", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "minSpacing", this.method.declaringClass);
                this._minSpacing = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._minSpacing == null) {
                newKey = ConfigUtil.newKey(RateLimit.class, "minSpacing");
                oldKey = ConfigUtil.oldKey(RateLimit.class, "minSpacing");
                this._minSpacing = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._minSpacing == null) {
                this._minSpacing = this.instance.minSpacing();
            }
        }
        return this._minSpacing;
    }

    public ChronoUnit minSpacingUnit() {
        if (this._minSpacingUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RateLimit.class, "minSpacingUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "minSpacingUnit", this.method.declaringClass, this.method.name);
                this._minSpacingUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RateLimit.class, "minSpacingUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "minSpacingUnit", this.method.declaringClass);
                this._minSpacingUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._minSpacingUnit == null) {
                newKey = ConfigUtil.newKey(RateLimit.class, "minSpacingUnit");
                oldKey = ConfigUtil.oldKey(RateLimit.class, "minSpacingUnit");
                this._minSpacingUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._minSpacingUnit == null) {
                this._minSpacingUnit = this.instance.minSpacingUnit();
            }
        }
        return this._minSpacingUnit;
    }

    public RateLimitType type() {
        if (this._type == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(RateLimit.class, "type", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "type", this.method.declaringClass, this.method.name);
                this._type = config.getOptionalValue(newKey, RateLimitType.class).or(() -> config.getOptionalValue(oldKey, RateLimitType.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(RateLimit.class, "type", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(RateLimit.class, "type", this.method.declaringClass);
                this._type = config.getOptionalValue(newKey, RateLimitType.class).or(() -> config.getOptionalValue(oldKey, RateLimitType.class)).orElse(null);
            }
            if (this._type == null) {
                newKey = ConfigUtil.newKey(RateLimit.class, "type");
                oldKey = ConfigUtil.oldKey(RateLimit.class, "type");
                this._type = config.getOptionalValue(newKey, RateLimitType.class).or(() -> config.getOptionalValue(oldKey, RateLimitType.class)).orElse(null);
            }
            if (this._type == null) {
                this._type = this.instance.type();
            }
        }
        return this._type;
    }

    public void materialize() {
        this.value();
        this.window();
        this.windowUnit();
        this.minSpacing();
        this.minSpacingUnit();
        this.type();
    }
}

