/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfig;
import io.smallrye.faulttolerance.config.ConfigUtil;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ApplyFaultToleranceConfigImpl
implements ApplyFaultToleranceConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final ApplyFaultTolerance instance;
    private final boolean onMethod;
    private String _value;

    private ApplyFaultToleranceConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.applyFaultTolerance;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyFaultTolerance.class);
    }

    public static ApplyFaultToleranceConfigImpl create(FaultToleranceMethod method) {
        if (method.applyFaultTolerance == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(ApplyFaultTolerance.class, method.method)) {
            return null;
        }
        return new ApplyFaultToleranceConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return ApplyFaultTolerance.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public String value() {
        if (this._value == null) {
            String key;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                key = ConfigUtil.oldKey(ApplyFaultTolerance.class, "value", this.method.declaringClass, this.method.name);
                this._value = config.getOptionalValue(key, String.class).orElse(null);
            } else {
                key = ConfigUtil.oldKey(ApplyFaultTolerance.class, "value", this.method.declaringClass);
                this._value = config.getOptionalValue(key, String.class).orElse(null);
            }
            if (this._value == null) {
                key = ConfigUtil.oldKey(ApplyFaultTolerance.class, "value");
                this._value = config.getOptionalValue(key, String.class).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public void materialize() {
        this.value();
    }
}

