package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link AsynchronousNonBlockingConfig} config interface, do not modify.
 */
public final class AsynchronousNonBlockingConfigImpl implements AsynchronousNonBlockingConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Description for the error message: a fully qualified method name.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final AsynchronousNonBlocking instance;

    private AsynchronousNonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(AsynchronousNonBlocking.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.asynchronousNonBlocking;
    }

    public static AsynchronousNonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.asynchronousNonBlocking == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("asynchronous-non-blocking.enabled", "AsynchronousNonBlocking/enabled", method.method)) {
            return null;
        }
        return new AsynchronousNonBlockingConfigImpl(method);
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return AsynchronousNonBlocking.class;
    }

    @Override
    public void materialize() {
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @AsynchronousNonBlocking on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @AsynchronousNonBlocking." + member + " on " + description + ": " + reason);
    }
}
