package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link FallbackConfig} config interface, do not modify.
 */
public final class FallbackConfigImpl implements FallbackConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Description for the error message: a fully qualified method name.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Fallback instance;

    /**
     * Cached value of the {@code Fallback.value} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends FallbackHandler<?>> _value;

    /**
     * Cached value of the {@code Fallback.fallbackMethod} annotation member; {@code null} if not looked up yet.
     */
    private String _fallbackMethod;

    /**
     * Cached value of the {@code Fallback.applyOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _applyOn;

    /**
     * Cached value of the {@code Fallback.skipOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _skipOn;

    private FallbackConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(Fallback.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.fallback;
    }

    public static FallbackConfigImpl create(FaultToleranceMethod method) {
        if (method.fallback == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("fallback.enabled", "Fallback/enabled", method.method)) {
            return null;
        }
        return new FallbackConfigImpl(method);
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Fallback.class;
    }

    @Override
    public Class<? extends FallbackHandler<?>> value() {
        if (_value == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.value";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Fallback/value";
                _value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_value == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.fallback.value";
                // <annotation>/<member>
                String oldKey = "Fallback/value";
                _value = config.getOptionalValue(newKey, Class.class).or(() -> config.getOptionalValue(oldKey, Class.class)).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public String fallbackMethod() {
        if (_fallbackMethod == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.fallback-method";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Fallback/fallbackMethod";
                _fallbackMethod = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (_fallbackMethod == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.fallback.fallback-method";
                // <annotation>/<member>
                String oldKey = "Fallback/fallbackMethod";
                _fallbackMethod = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (_fallbackMethod == null) {
                // annotation value
                _fallbackMethod = instance.fallbackMethod();
            }
        }
        return _fallbackMethod;
    }

    @Override
    public Class<? extends Throwable>[] applyOn() {
        if (_applyOn == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.apply-on";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Fallback/applyOn";
                _applyOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_applyOn == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.fallback.apply-on";
                // <annotation>/<member>
                String oldKey = "Fallback/applyOn";
                _applyOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_applyOn == null) {
                // annotation value
                _applyOn = instance.applyOn();
            }
        }
        return _applyOn;
    }

    @Override
    public Class<? extends Throwable>[] skipOn() {
        if (_skipOn == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.skip-on";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Fallback/skipOn";
                _skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_skipOn == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.fallback.skip-on";
                // <annotation>/<member>
                String oldKey = "Fallback/skipOn";
                _skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_skipOn == null) {
                // annotation value
                _skipOn = instance.skipOn();
            }
        }
        return _skipOn;
    }

    @Override
    public void materialize() {
        value();
        fallbackMethod();
        applyOn();
        skipOn();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Fallback on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Fallback." + member + " on " + description + ": " + reason);
    }
}
