/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.config;

import io.smallrye.graphql.bootstrap.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class GraphQLConfig
implements Config {
    @Deprecated
    @Inject
    @ConfigProperty(name="mp.graphql.exceptionsBlackList", defaultValue="")
    private Optional<List<String>> blackList;
    @Inject
    @ConfigProperty(name="mp.graphql.hideErrorMessage", defaultValue="")
    private Optional<List<String>> hideList;
    @Deprecated
    @Inject
    @ConfigProperty(name="mp.graphql.exceptionsWhiteList", defaultValue="")
    private Optional<List<String>> whiteList;
    @Inject
    @ConfigProperty(name="mp.graphql.showErrorMessage", defaultValue="")
    private Optional<List<String>> showList;
    @Inject
    @ConfigProperty(name="mp.graphql.defaultErrorMessage", defaultValue="Server Error")
    private String defaultErrorMessage;
    @Inject
    @ConfigProperty(name="smallrye.graphql.printDataFetcherException", defaultValue="false")
    private boolean printDataFetcherException;
    @Inject
    @ConfigProperty(name="smallrye.graphql.allowGet", defaultValue="false")
    private boolean allowGet;
    @Inject
    @ConfigProperty(name="smallrye.graphql.metrics.enabled", defaultValue="false")
    private boolean metricsEnabled;
    @Inject
    @ConfigProperty(name="smallrye.graphql.tracing.enabled", defaultValue="false")
    private boolean tracingEnabled;
    @Inject
    @ConfigProperty(name="smallrye.graphql.validation.enabled", defaultValue="false")
    private boolean validationEnabled;
    @Inject
    @ConfigProperty(name="smallrye.graphql.schema.includeScalars", defaultValue="true")
    private boolean includeScalarsInSchema;
    @Inject
    @ConfigProperty(name="smallrye.graphql.schema.includeDirectives", defaultValue="false")
    private boolean includeDirectivesInSchema;
    @Inject
    @ConfigProperty(name="smallrye.graphql.schema.includeSchemaDefinition", defaultValue="false")
    private boolean includeSchemaDefinitionInSchema;
    @Inject
    @ConfigProperty(name="smallrye.graphql.schema.includeIntrospectionTypes", defaultValue="false")
    private boolean includeIntrospectionTypesInSchema;
    @Inject
    @ConfigProperty(name="smallrye.graphql.logPayload", defaultValue="false")
    private boolean logPayload;
    @Inject
    @ConfigProperty(name="smallrye.graphql.fieldVisibility", defaultValue="default")
    private String fieldVisibility;

    public void init(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.hideList = this.mergeList(this.hideList, this.blackList);
        this.showList = this.mergeList(this.showList, this.whiteList);
    }

    public String getDefaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    public boolean isPrintDataFetcherException() {
        return this.printDataFetcherException;
    }

    public Optional<List<String>> getHideErrorMessageList() {
        return this.hideList;
    }

    public Optional<List<String>> getShowErrorMessageList() {
        return this.showList;
    }

    public boolean isAllowGet() {
        return this.allowGet;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public boolean isIncludeDirectivesInSchema() {
        return this.includeDirectivesInSchema;
    }

    public boolean isIncludeSchemaDefinitionInSchema() {
        return this.includeSchemaDefinitionInSchema;
    }

    public boolean isIncludeIntrospectionTypesInSchema() {
        return this.includeIntrospectionTypesInSchema;
    }

    public boolean isIncludeScalarsInSchema() {
        return this.includeScalarsInSchema;
    }

    public boolean logPayload() {
        return this.logPayload;
    }

    public String getFieldVisibility() {
        return this.fieldVisibility;
    }

    public void setHideErrorMessageList(Optional<List<String>> hideList) {
        this.hideList = hideList;
    }

    public void setShowErrorMessageList(Optional<List<String>> showList) {
        this.showList = showList;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public void setPrintDataFetcherException(boolean printDataFetcherException) {
        this.printDataFetcherException = printDataFetcherException;
    }

    public void setAllowGet(boolean allowGet) {
        this.allowGet = allowGet;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public void setIncludeScalarsInSchema(boolean includeScalarsInSchema) {
        this.includeScalarsInSchema = includeScalarsInSchema;
    }

    public void setIncludeDirectivesInSchema(boolean includeDirectivesInSchema) {
        this.includeDirectivesInSchema = includeDirectivesInSchema;
    }

    public void setIncludeSchemaDefinitionInSchema(boolean includeSchemaDefinitionInSchema) {
        this.includeSchemaDefinitionInSchema = includeSchemaDefinitionInSchema;
    }

    public void setIncludeIntrospectionTypesInSchema(boolean includeIntrospectionTypesInSchema) {
        this.includeIntrospectionTypesInSchema = includeIntrospectionTypesInSchema;
    }

    public void setLogPayload(boolean logPayload) {
        this.logPayload = logPayload;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    private Optional<List<String>> mergeList(Optional<List<String>> currentList, Optional<List<String>> deprecatedList) {
        ArrayList combined = new ArrayList();
        if (deprecatedList.isPresent()) {
            combined.addAll(deprecatedList.get());
        }
        if (currentList.isPresent()) {
            combined.addAll(currentList.get());
        }
        if (!combined.isEmpty()) {
            return Optional.of(combined);
        }
        return Optional.empty();
    }
}

