/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.producer;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.bootstrap.Bootstrap;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.execution.SchemaPrinter;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.spi.MetricsService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ApplicationScoped
public class GraphQLProducer {
    @Inject
    GraphQLConfig graphQLConfig;
    @Produces
    SchemaPrinter schemaPrinter;
    @Produces
    ExecutionService executionService;
    @Produces
    GraphQLSchema graphQLSchema;
    @Produces
    Schema schema;

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public GraphQLSchema initialize(Schema schema) {
        this.schema = schema;
        return this.initialize();
    }

    public GraphQLSchema initialize() {
        this.graphQLSchema = Bootstrap.bootstrap((Schema)this.schema, (Config)this.graphQLConfig);
        if (this.graphQLConfig.isMetricsEnabled()) {
            MetricRegistry vendorRegistry = MetricsService.load().getMetricRegistry(MetricRegistry.Type.VENDOR);
            Bootstrap.registerMetrics((Schema)this.schema, (MetricRegistry)vendorRegistry);
        }
        this.executionService = new ExecutionService((Config)this.graphQLConfig, this.graphQLSchema);
        this.schemaPrinter = new SchemaPrinter((Config)this.graphQLConfig);
        return this.graphQLSchema;
    }

    @Produces
    @RequestScoped
    public Context getContext() {
        return SmallRyeContext.getContext();
    }
}

