/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.tracing;

import graphql.ExecutionInput;
import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.spi.EventingService;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import javax.enterprise.inject.spi.CDI;

public class TracingService
implements EventingService {
    private final String SPAN_CLASS = "io.opentracing.Span";
    private final String SCOPE_CLASS = "io.opentracing.Scope";
    private final Map<String, Span> spans = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<String, Scope> scopes = Collections.synchronizedMap(new IdentityHashMap());
    private Tracer tracer;
    private static final String UNDERSCORE = "_";
    private static final String EMPTY = "";
    private static final String PREFIX = "GraphQL";

    public void beforeExecute(Context context) {
        ExecutionInput executionInput = (ExecutionInput)context.unwrap(ExecutionInput.class);
        String operationName = TracingService.getOperationName(executionInput);
        Span span = this.getTracer().buildSpan(operationName).asChildOf(this.getTracer().activeSpan()).withTag("graphql.executionId", context.getExecutionId()).withTag("graphql.operationType", this.getOperationNameString(context.getRequestedOperationTypes())).withTag("graphql.operationName", context.getOperationName().orElse(EMPTY)).start();
        Scope scope = this.tracer.activateSpan(span);
        this.spans.put(context.getExecutionId(), span);
        this.scopes.put(context.getExecutionId(), scope);
    }

    public void afterExecute(Context context) {
        Span span = this.spans.remove(context.getExecutionId());
        if (span != null) {
            this.scopes.get(context.getExecutionId()).close();
            span.finish();
        }
    }

    public void errorExecute(String executionId, Throwable t) {
        Span span = this.spans.remove(executionId);
        if (span != null) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("event.object", t);
            error.put("event", "error");
            span.log(error);
            span.finish();
        }
    }

    public void beforeDataFetch(Context context) {
        DataFetchingEnvironment env = (DataFetchingEnvironment)context.unwrap(DataFetchingEnvironment.class);
        Span parentSpan = this.getParentSpan(this.getTracer(), env);
        Span span = this.getTracer().buildSpan(this.getOperationName(env)).asChildOf(parentSpan).withTag("graphql.executionId", context.getExecutionId()).withTag("graphql.operationType", this.getOperationNameString(context.getOperationType())).withTag("graphql.operationName", context.getOperationName().orElse(EMPTY)).withTag("graphql.parent", context.getParentTypeName().orElse(EMPTY)).withTag("graphql.field", context.getFieldName()).withTag("graphql.path", context.getPath()).start();
        Scope scope = this.tracer.activateSpan(span);
        GraphQLContext graphQLContext = (GraphQLContext)env.getContext();
        graphQLContext.put((Object)"io.opentracing.Span", (Object)parentSpan);
        graphQLContext.put((Object)"io.opentracing.Scope", (Object)scope);
    }

    public void afterDataFetch(Context context) {
        Span span = this.tracer.activeSpan();
        Scope scope = (Scope)((GraphQLContext)((DataFetchingEnvironment)context.unwrap(DataFetchingEnvironment.class)).getContext()).get((Object)"io.opentracing.Scope");
        scope.close();
        span.finish();
    }

    public void errorDataFetch(String executionId, Throwable t) {
        Span span = this.spans.get(executionId);
        if (span != null) {
            this.logError(span, t);
        }
    }

    public String getConfigKey() {
        return "smallrye.graphql.tracing.enabled";
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get();
        }
        return this.tracer;
    }

    private Span getParentSpan(Tracer tracer, DataFetchingEnvironment env) {
        GraphQLContext localContext = (GraphQLContext)env.getLocalContext();
        if (localContext != null && localContext.hasKey((Object)"io.opentracing.Span")) {
            return (Span)localContext.get((Object)"io.opentracing.Span");
        }
        GraphQLContext rootContext = (GraphQLContext)env.getContext();
        if (rootContext != null && rootContext.hasKey((Object)"io.opentracing.Span")) {
            return (Span)rootContext.get((Object)"io.opentracing.Span");
        }
        return tracer.activeSpan();
    }

    private void logError(Span span, Throwable throwable) {
        if (throwable instanceof InvocationTargetException || throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        HashMap<String, String> error = new HashMap<String, String>();
        if (throwable != null) {
            error.put("error.object", throwable.getMessage());
        }
        error.put("event", "error");
        span.log(error);
        span.setTag("error", true);
    }

    private String getOperationName(DataFetchingEnvironment env) {
        String parent = this.getName(env.getParentType());
        String name = "GraphQL:" + parent + "." + env.getField().getName();
        return name;
    }

    private static String getOperationName(ExecutionInput executionInput) {
        if (executionInput.getOperationName() != null && !executionInput.getOperationName().isEmpty()) {
            return "GraphQL:" + executionInput.getOperationName();
        }
        return PREFIX;
    }

    private String getName(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNamedType) {
            return ((GraphQLNamedType)graphQLType).getName();
        }
        if (graphQLType instanceof GraphQLNonNull) {
            return this.getName(((GraphQLNonNull)graphQLType).getWrappedType());
        }
        if (graphQLType instanceof GraphQLList) {
            return this.getName(((GraphQLList)graphQLType).getWrappedType());
        }
        return EMPTY;
    }

    private String getOperationNameString(List<String> types) {
        return String.join((CharSequence)UNDERSCORE, types);
    }

    private String getOperationNameString(String ... types) {
        return this.getOperationNameString(Arrays.asList(types));
    }
}

