/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.tracing;

import graphql.schema.DataFetchingEnvironment;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.spi.EventingService;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.CDI;

@Priority(value=0)
public class TracingService
implements EventingService {
    private final String SPAN_CLASS = "io.opentracing.Span";
    private final String SCOPE_CLASS = "io.opentracing.Scope";
    private final Map<String, Span> spans = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<String, Scope> scopes = Collections.synchronizedMap(new IdentityHashMap());
    private Tracer tracer;
    private static final String UNDERSCORE = "_";
    private static final String EMPTY = "";
    private static final String PREFIX = "GraphQL";

    public void beforeExecute(Context context) {
        String operationName = TracingService.getOperationName(context);
        Span span = this.getTracer().buildSpan(operationName).asChildOf(this.getTracer().activeSpan()).withTag("graphql.executionId", context.getExecutionId()).withTag("graphql.operationType", this.getOperationNameString(context.getRequestedOperationTypes())).withTag("graphql.operationName", context.getOperationName().orElse(EMPTY)).start();
        Scope scope = this.tracer.activateSpan(span);
        this.spans.put(context.getExecutionId(), span);
        this.scopes.put(context.getExecutionId(), scope);
    }

    public void afterExecute(Context context) {
        Span span = this.spans.remove(context.getExecutionId());
        if (span != null) {
            this.scopes.get(context.getExecutionId()).close();
            span.finish();
        }
    }

    public void errorExecute(String executionId, Throwable t) {
        Span span = this.spans.remove(executionId);
        if (span != null) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("event.object", t);
            error.put("event", "error");
            span.log(error);
            span.finish();
        }
    }

    public void beforeDataFetch(Context context) {
        Span parentSpan = this.getParentSpan(this.getTracer(), context);
        Span span = this.getTracer().buildSpan(this.getOperationNameForParentType(context)).asChildOf(parentSpan).withTag("graphql.executionId", context.getExecutionId()).withTag("graphql.operationType", this.getOperationNameString(context.getOperationType())).withTag("graphql.operationName", context.getOperationName().orElse(EMPTY)).withTag("graphql.parent", context.getParentTypeName().orElse(EMPTY)).withTag("graphql.field", context.getFieldName()).withTag("graphql.path", context.getPath()).start();
        Scope scope = this.tracer.activateSpan(span);
        DataFetchingEnvironment dfe = (DataFetchingEnvironment)context.unwrap(DataFetchingEnvironment.class);
        dfe.getGraphQlContext().put((Object)"io.opentracing.Span", (Object)parentSpan);
        dfe.getGraphQlContext().put((Object)"io.opentracing.Scope", (Object)scope);
    }

    public void afterDataFetch(Context context) {
        Span span = this.tracer.activeSpan();
        DataFetchingEnvironment dfe = (DataFetchingEnvironment)context.unwrap(DataFetchingEnvironment.class);
        Scope scope = (Scope)dfe.getGraphQlContext().get((Object)"io.opentracing.Scope");
        scope.close();
        span.finish();
    }

    public void errorDataFetch(String executionId, Throwable t) {
        Span span = this.spans.get(executionId);
        if (span != null) {
            this.logError(span, t);
        }
    }

    public String getConfigKey() {
        return "smallrye.graphql.tracing.enabled";
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get();
        }
        return this.tracer;
    }

    private Span getParentSpan(Tracer tracer, Context context) {
        DataFetchingEnvironment dfe = (DataFetchingEnvironment)context.unwrap(DataFetchingEnvironment.class);
        if (dfe.getGraphQlContext().hasKey((Object)"io.opentracing.Span")) {
            return (Span)dfe.getGraphQlContext().get((Object)"io.opentracing.Span");
        }
        return tracer.activeSpan();
    }

    private void logError(Span span, Throwable throwable) {
        if (throwable instanceof InvocationTargetException || throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        HashMap<String, String> error = new HashMap<String, String>();
        if (throwable != null) {
            error.put("error.object", throwable.getMessage());
        }
        error.put("event", "error");
        span.log(error);
        span.setTag("error", true);
    }

    private String getOperationNameForParentType(Context context) {
        String parent = context.getParentTypeName().orElse(EMPTY);
        String name = "GraphQL:" + parent + "." + context.getFieldName();
        return name;
    }

    private static String getOperationName(Context context) {
        if (context.getOperationName().isPresent()) {
            return "GraphQL:" + (String)context.getOperationName().get();
        }
        return PREFIX;
    }

    private String getOperationNameString(List<String> types) {
        return String.join((CharSequence)UNDERSCORE, types);
    }

    private String getOperationNameString(String ... types) {
        return this.getOperationNameString(Arrays.asList(types));
    }
}

