/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.event;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.cdi.event.AfterDataFetch;
import io.smallrye.graphql.cdi.event.AfterExecute;
import io.smallrye.graphql.cdi.event.BeforeDataFetch;
import io.smallrye.graphql.cdi.event.BeforeExecute;
import io.smallrye.graphql.cdi.event.ErrorDataFetch;
import io.smallrye.graphql.cdi.event.ErrorExecute;
import io.smallrye.graphql.cdi.event.ErrorInfo;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;

@Priority(value=200)
public class EventsService
implements EventingService {
    public GraphQLSchema.Builder beforeSchemaBuild(GraphQLSchema.Builder builder) {
        this.fire(builder, new Annotation[0]);
        return builder;
    }

    public Operation createOperation(Operation operation) {
        this.fire(operation, new Annotation[0]);
        return operation;
    }

    public GraphQL.Builder beforeGraphQLBuild(GraphQL.Builder builder) {
        this.fire(builder, new Annotation[0]);
        return builder;
    }

    public void beforeExecute(Context context) {
        this.fire(context, BeforeExecute.LITERAL);
    }

    public void afterExecute(Context context) {
        this.fire(context, AfterExecute.LITERAL);
    }

    public void beforeDataFetch(Context context) {
        this.fire(context, BeforeDataFetch.LITERAL);
    }

    public void beforeInvoke(InvokeInfo invokeInfo) throws Exception {
        this.fire(invokeInfo, new Annotation[0]);
    }

    public void afterDataFetch(Context context) {
        this.fire(context, AfterDataFetch.LITERAL);
    }

    public void errorExecute(Context context, Throwable t) {
        this.fire(new ErrorInfo(context, t), ErrorExecute.LITERAL);
    }

    public void errorDataFetch(Context context, Throwable t) {
        this.fire(new ErrorInfo(context, t), ErrorDataFetch.LITERAL);
    }

    public String getConfigKey() {
        return "smallrye.graphql.events.enabled";
    }

    private void fire(Object o, Annotation ... annotation) {
        try {
            BeanManager beanManager;
            CDI current = CDI.current();
            if (current != null && (beanManager = current.getBeanManager()) != null) {
                beanManager.getEvent().select(annotation).fire(o);
            }
        }
        catch (IllegalStateException ise) {
            ise.printStackTrace();
        }
    }
}

