/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.context;

import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class GraphQLThreadContextProvider
implements ThreadContextProvider {
    public static final String TYPE = "MICROPROFILE_GRAPHQL_CONTEXT";

    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        SmallRyeContext currentSmallRyeContext = SmallRyeContextManager.getCurrentSmallRyeContext();
        return () -> {
            SmallRyeContext current = this.restore(currentSmallRyeContext);
            return () -> this.restore(current);
        };
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        return () -> {
            SmallRyeContext current = this.restore(null);
            return () -> this.restore(current);
        };
    }

    public String getThreadContextType() {
        return TYPE;
    }

    private SmallRyeContext restore(SmallRyeContext context) {
        SmallRyeContext currentSmallRyeContext = SmallRyeContextManager.getCurrentSmallRyeContext();
        if (context == null) {
            SmallRyeContextManager.clearCurrentSmallRyeContext();
        } else {
            SmallRyeContextManager.restore((SmallRyeContext)context);
        }
        return currentSmallRyeContext;
    }
}

