/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.validation;

import io.smallrye.graphql.cdi.validation.BeanValidationException;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.spi.EventingService;
import io.smallrye.graphql.spi.LookupService;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

public class ValidationService
implements EventingService {
    private ValidatorFactory VALIDATOR_FACTORY = null;
    private final LookupService lookupService = LookupService.get();

    public void beforeInvoke(InvokeInfo invokeInfo) throws Exception {
        Set violations;
        Object declaringObject = invokeInfo.getOperationInstance();
        Method method = invokeInfo.getOperationMethod();
        Object[] arguments = invokeInfo.getOperationTransformedArguments();
        if (this.VALIDATOR_FACTORY == null) {
            this.VALIDATOR_FACTORY = this.getValidatorFactory();
        }
        if (!(violations = this.VALIDATOR_FACTORY.getValidator().forExecutables().validateParameters(declaringObject, method, arguments, new Class[0])).isEmpty()) {
            throw new BeanValidationException(violations, method);
        }
    }

    public String getConfigKey() {
        return "smallrye.graphql.validation.enabled";
    }

    private ValidatorFactory getValidatorFactory() {
        try {
            return (ValidatorFactory)this.lookupService.getInstance(ValidatorFactory.class).get();
        }
        catch (Exception t) {
            return Validation.buildDefaultValidatorFactory();
        }
    }
}

