/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi;

import io.smallrye.graphql.cdi.CDIManagedInstance;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.spi.ManagedInstance;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Set;

public class CdiLookupService
implements LookupService {
    public String getName() {
        return "CDI";
    }

    public Class<?> getClass(Class<?> declaringClass) {
        ManagedInstance<?> declaringObject = this.getInstance(declaringClass);
        return declaringObject.getClass();
    }

    public <T> ManagedInstance<T> getInstance(Class<T> declaringClass) {
        CDI cdi = CDI.current();
        Bean bean = (Bean)this.getExactlyOneObject(cdi.getBeanManager().getBeans(declaringClass, new Annotation[0]));
        boolean isDependentScope = bean.getScope().equals(Dependent.class);
        return new CDIManagedInstance(cdi.select(declaringClass, new Annotation[0]), isDependentScope);
    }

    private <T> T getExactlyOneObject(Set<T> set) {
        if (set.size() > 1) {
            throw new AmbiguousResolutionException();
        }
        if (set.size() == 0) {
            throw new UnsatisfiedResolutionException();
        }
        return set.iterator().next();
    }

    public boolean isResolvable(Class<?> declaringClass) {
        return CDI.current().select(declaringClass, new Annotation[0]).isResolvable();
    }
}

