/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.config;

import io.smallrye.graphql.spi.config.LogPayloadOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class MicroProfileConfig
implements io.smallrye.graphql.spi.config.Config {
    private List<String> hideList;
    private List<String> showList;
    private String defaultErrorMessage;
    private Boolean printDataFetcherException;
    private Boolean allowGet;
    private Boolean allowPostWithQueryParameters;
    private Boolean metricsEnabled;
    private Boolean tracingEnabled;
    private Boolean validationEnabled;
    private Boolean eventsEnabled;
    private Boolean federationEnabled;
    private Boolean includeScalarsInSchema;
    private Boolean includeDirectivesInSchema;
    private Boolean includeSchemaDefinitionInSchema;
    private Boolean includeIntrospectionTypesInSchema;
    private LogPayloadOption logPayload;
    private String fieldVisibility;
    private List<String> unwrapExceptions;
    private List<String> errorExtensionFields;
    private Integer parserMaxTokens;
    private Integer parserMaxWhitespaceTokens;
    private Boolean parserCaptureSourceLocation;
    private Boolean parserCaptureLineComments;
    private Boolean parserCaptureIgnoredChars;
    private Integer queryComplexityInstrumentation;
    private Integer queryDepthInstrumentation;

    public String getName() {
        return "MicroProfile Config Service";
    }

    public String getDefaultErrorMessage() {
        if (this.defaultErrorMessage == null) {
            this.defaultErrorMessage = this.getStringConfigValue("mp.graphql.defaultErrorMessage", "System error");
        }
        return this.defaultErrorMessage;
    }

    public boolean isPrintDataFetcherException() {
        if (this.printDataFetcherException == null) {
            this.printDataFetcherException = this.getBooleanConfigValue("smallrye.graphql.printDataFetcherException");
        }
        return this.printDataFetcherException;
    }

    public Optional<List<String>> getHideErrorMessageList() {
        if (this.hideList == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            List<String> blackList = microProfileConfig.getOptionalValues("mp.graphql.exceptionsBlackList", String.class).orElse(List.of());
            List<String> currentList = microProfileConfig.getOptionalValues("mp.graphql.hideErrorMessage", String.class).orElse(List.of());
            this.hideList = this.mergeList(currentList, blackList).orElse(null);
        }
        return Optional.ofNullable(this.hideList);
    }

    public Optional<List<String>> getShowErrorMessageList() {
        if (this.showList == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            List<String> whiteList = microProfileConfig.getOptionalValues("mp.graphql.exceptionsWhiteList", String.class).orElse(List.of());
            List<String> currentList = microProfileConfig.getOptionalValues("mp.graphql.showErrorMessage", String.class).orElse(List.of());
            this.showList = this.mergeList(currentList, whiteList).orElse(null);
        }
        return Optional.ofNullable(this.showList);
    }

    public boolean isAllowGet() {
        if (this.allowGet == null) {
            this.allowGet = this.getBooleanConfigValue("smallrye.graphql.allowGet");
        }
        return this.allowGet;
    }

    public boolean isAllowPostWithQueryParameters() {
        if (this.allowPostWithQueryParameters == null) {
            this.allowPostWithQueryParameters = this.getBooleanConfigValue("smallrye.graphql.allowPostWithQueryParameters");
        }
        return this.allowPostWithQueryParameters;
    }

    public boolean isMetricsEnabled() {
        if (this.metricsEnabled == null) {
            this.metricsEnabled = this.getBooleanConfigValue("smallrye.graphql.metrics.enabled");
        }
        return this.metricsEnabled;
    }

    public boolean isTracingEnabled() {
        if (this.tracingEnabled == null) {
            this.tracingEnabled = this.getBooleanConfigValue("smallrye.graphql.tracing.enabled");
        }
        return this.tracingEnabled;
    }

    public boolean isValidationEnabled() {
        if (this.validationEnabled == null) {
            this.validationEnabled = this.getBooleanConfigValue("smallrye.graphql.validation.enabled");
        }
        return this.validationEnabled;
    }

    public boolean isEventsEnabled() {
        if (this.eventsEnabled == null) {
            this.eventsEnabled = this.getBooleanConfigValue("smallrye.graphql.events.enabled");
        }
        return this.eventsEnabled;
    }

    public boolean isFederationEnabled() {
        if (this.federationEnabled == null) {
            this.federationEnabled = this.getBooleanConfigValue("smallrye.graphql.federation.enabled", true);
        }
        return this.federationEnabled;
    }

    public boolean isIncludeScalarsInSchema() {
        if (this.includeScalarsInSchema == null) {
            this.includeScalarsInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeScalars", true);
        }
        return this.includeScalarsInSchema;
    }

    public boolean isIncludeDirectivesInSchema() {
        if (this.includeDirectivesInSchema == null) {
            this.includeDirectivesInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeDirectives");
        }
        return this.includeDirectivesInSchema;
    }

    public boolean isIncludeSchemaDefinitionInSchema() {
        if (this.includeSchemaDefinitionInSchema == null) {
            this.includeSchemaDefinitionInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeSchemaDefinition");
        }
        return this.includeSchemaDefinitionInSchema;
    }

    public boolean isIncludeIntrospectionTypesInSchema() {
        if (this.includeIntrospectionTypesInSchema == null) {
            this.includeIntrospectionTypesInSchema = this.getBooleanConfigValue("smallrye.graphql.schema.includeIntrospectionTypes");
        }
        return this.includeIntrospectionTypesInSchema;
    }

    public LogPayloadOption logPayload() {
        if (this.logPayload == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.logPayload = microProfileConfig.getOptionalValue("smallrye.graphql.logPayload", LogPayloadOption.class).orElse(LogPayloadOption.off);
        }
        return this.logPayload;
    }

    public Optional<Boolean> isParserCaptureIgnoredChars() {
        if (this.parserCaptureIgnoredChars == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.parserCaptureIgnoredChars = microProfileConfig.getOptionalValue("smallrye.graphql.parser.capture.ignoredChars", Boolean.class).orElse(null);
        }
        return Optional.ofNullable(this.parserCaptureIgnoredChars);
    }

    public Optional<Boolean> isParserCaptureLineComments() {
        if (this.parserCaptureLineComments == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.parserCaptureLineComments = microProfileConfig.getOptionalValue("smallrye.graphql.parser.capture.lineComments", Boolean.class).orElse(null);
        }
        return Optional.ofNullable(this.parserCaptureLineComments);
    }

    public Optional<Boolean> isParserCaptureSourceLocation() {
        if (this.parserCaptureSourceLocation == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.parserCaptureSourceLocation = microProfileConfig.getOptionalValue("smallrye.graphql.parser.capture.sourceLocation", Boolean.class).orElse(null);
        }
        return Optional.ofNullable(this.parserCaptureSourceLocation);
    }

    public Optional<Integer> getParserMaxTokens() {
        if (this.parserMaxTokens == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.parserMaxTokens = microProfileConfig.getOptionalValue("smallrye.graphql.parser.maxTokens", Integer.class).orElse(null);
        }
        return Optional.ofNullable(this.parserMaxTokens);
    }

    public Optional<Integer> getParserMaxWhitespaceTokens() {
        if (this.parserMaxWhitespaceTokens == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.parserMaxWhitespaceTokens = microProfileConfig.getOptionalValue("smallrye.graphql.parser.maxWhitespaceTokens", Integer.class).orElse(null);
        }
        return Optional.ofNullable(this.parserMaxWhitespaceTokens);
    }

    public String getFieldVisibility() {
        if (this.fieldVisibility == null) {
            this.fieldVisibility = this.getStringConfigValue("smallrye.graphql.fieldVisibility", "default");
        }
        return this.fieldVisibility;
    }

    public Optional<List<String>> getUnwrapExceptions() {
        if (this.unwrapExceptions == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.unwrapExceptions = microProfileConfig.getOptionalValues("smallrye.graphql.unwrapExceptions", String.class).orElse(null);
        }
        return Optional.ofNullable(this.unwrapExceptions);
    }

    public Optional<List<String>> getErrorExtensionFields() {
        if (this.errorExtensionFields == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.errorExtensionFields = microProfileConfig.getOptionalValues("smallrye.graphql.errorExtensionFields", String.class).orElse(null);
        }
        return Optional.ofNullable(this.errorExtensionFields);
    }

    public Optional<Integer> getQueryComplexityInstrumentation() {
        if (this.queryComplexityInstrumentation == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.queryComplexityInstrumentation = microProfileConfig.getOptionalValue("smallrye.graphql.instrumentation.queryComplexity", Integer.class).orElse(null);
        }
        return Optional.ofNullable(this.queryComplexityInstrumentation);
    }

    public Optional<Integer> getQueryDepthInstrumentation() {
        if (this.queryDepthInstrumentation == null) {
            Config microProfileConfig = ConfigProvider.getConfig();
            this.queryDepthInstrumentation = microProfileConfig.getOptionalValue("smallrye.graphql.instrumentation.queryDepth", Integer.class).orElse(null);
        }
        return Optional.ofNullable(this.queryDepthInstrumentation);
    }

    public <T> T getConfigValue(String key, Class<T> type, T defaultValue) {
        Config microProfileConfig = ConfigProvider.getConfig();
        return microProfileConfig.getOptionalValue(key, type).orElse(defaultValue);
    }

    public void setHideErrorMessageList(List<String> hideList) {
        this.hideList = hideList;
    }

    public void setShowErrorMessageList(List<String> showList) {
        this.showList = showList;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public void setPrintDataFetcherException(boolean printDataFetcherException) {
        this.printDataFetcherException = printDataFetcherException;
    }

    public void setAllowGet(boolean allowGet) {
        this.allowGet = allowGet;
    }

    public void setAllowPostWithQueryParameters(boolean allowPostWithQueryParameters) {
        this.allowPostWithQueryParameters = allowPostWithQueryParameters;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public void setIncludeScalarsInSchema(boolean includeScalarsInSchema) {
        this.includeScalarsInSchema = includeScalarsInSchema;
    }

    public void setIncludeDirectivesInSchema(boolean includeDirectivesInSchema) {
        this.includeDirectivesInSchema = includeDirectivesInSchema;
    }

    public void setIncludeSchemaDefinitionInSchema(boolean includeSchemaDefinitionInSchema) {
        this.includeSchemaDefinitionInSchema = includeSchemaDefinitionInSchema;
    }

    public void setIncludeIntrospectionTypesInSchema(boolean includeIntrospectionTypesInSchema) {
        this.includeIntrospectionTypesInSchema = includeIntrospectionTypesInSchema;
    }

    public void setLogPayload(LogPayloadOption logPayload) {
        this.logPayload = logPayload;
    }

    public void setParserCaptureIgnoredChars(Boolean parserCaptureIgnoredChars) {
        this.parserCaptureIgnoredChars = parserCaptureIgnoredChars;
    }

    public void setParserCaptureLineComments(Boolean parserCaptureLineComments) {
        this.parserCaptureLineComments = parserCaptureLineComments;
    }

    public void setParserCaptureSourceLocation(Boolean parserCaptureSourceLocation) {
        this.parserCaptureSourceLocation = parserCaptureSourceLocation;
    }

    public void setParserMaxTokens(Integer parserMaxTokens) {
        this.parserMaxTokens = parserMaxTokens;
    }

    public void setParserMaxWhitespaceTokens(Integer parserMaxWhitespaceTokens) {
        this.parserMaxWhitespaceTokens = parserMaxWhitespaceTokens;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    public void setUnwrapExceptions(List<String> unwrapExceptions) {
        this.unwrapExceptions = unwrapExceptions;
    }

    public void setErrorExtensionFields(List<String> errorExtensionFields) {
        this.errorExtensionFields = errorExtensionFields;
    }

    public void setPrintDataFetcherException(Boolean printDataFetcherException) {
        this.printDataFetcherException = printDataFetcherException;
    }

    public void setAllowGet(Boolean allowGet) {
        this.allowGet = allowGet;
    }

    public void setAllowPostWithQueryParameters(Boolean allowPostWithQueryParameters) {
        this.allowPostWithQueryParameters = allowPostWithQueryParameters;
    }

    public void setMetricsEnabled(Boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setTracingEnabled(Boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public void setValidationEnabled(Boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public void setEventsEnabled(Boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
    }

    public void setIncludeScalarsInSchema(Boolean includeScalarsInSchema) {
        this.includeScalarsInSchema = includeScalarsInSchema;
    }

    public void setIncludeDirectivesInSchema(Boolean includeDirectivesInSchema) {
        this.includeDirectivesInSchema = includeDirectivesInSchema;
    }

    public void setIncludeSchemaDefinitionInSchema(Boolean includeSchemaDefinitionInSchema) {
        this.includeSchemaDefinitionInSchema = includeSchemaDefinitionInSchema;
    }

    public void setIncludeIntrospectionTypesInSchema(Boolean includeIntrospectionTypesInSchema) {
        this.includeIntrospectionTypesInSchema = includeIntrospectionTypesInSchema;
    }

    public void setQueryComplexityInstrumentation(Integer queryComplexityInstrumentation) {
        this.queryComplexityInstrumentation = queryComplexityInstrumentation;
    }

    public void getQueryDepthInstrumentation(Integer queryDepthInstrumentation) {
        this.queryDepthInstrumentation = queryDepthInstrumentation;
    }

    private Optional<List<String>> mergeList(List<String> currentList, List<String> deprecatedList) {
        ArrayList<String> combined = new ArrayList<String>(deprecatedList);
        combined.addAll(currentList);
        if (!combined.isEmpty()) {
            return Optional.of(combined);
        }
        return Optional.empty();
    }

    private String getStringConfigValue(String key, String defaultValue) {
        return this.getConfigValue(key, String.class, defaultValue);
    }

    private boolean getBooleanConfigValue(String key) {
        return this.getBooleanConfigValue(key, false);
    }

    private boolean getBooleanConfigValue(String key, boolean defaultValue) {
        return this.getConfigValue(key, Boolean.class, defaultValue);
    }
}

