/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.metrics;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.cdi.metrics.MetricMeasurement;
import io.smallrye.graphql.spi.MetricsService;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.jboss.logging.Logger;

public class MPMetricsService
implements MetricsService {
    private MetricRegistry metricRegistry;
    private final Map<Long, MetricMeasurement> metricsMemory = new ConcurrentHashMap<Long, MetricMeasurement>();
    private static final String METRIC_NAME = "mp_graphql";
    private Logger LOG = Logger.getLogger(MPMetricsService.class);

    public MPMetricsService() {
        this.getMetricRegistry();
    }

    private MetricRegistry getMetricRegistry() {
        if (this.metricRegistry == null) {
            this.metricRegistry = (MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[]{new VendorType()}).get();
        }
        return this.metricRegistry;
    }

    private Tag[] getTags(MetricMeasurement metricMeasurement) {
        return new Tag[]{new Tag("name", metricMeasurement.getName()), new Tag("type", metricMeasurement.getOperationType()), new Tag("source", String.valueOf(metricMeasurement.isSource()))};
    }

    public void start(Long measurementId, Context context) {
        this.metricsMemory.put(measurementId, new MetricMeasurement(context.getFieldName(), context.hasSource(), context.getOperationType(), System.nanoTime()));
        this.LOG.tracef("(" + measurementId + ") Started recording metrics for: %s", (Object)context.getFieldName());
    }

    public void end(Long measurementId) {
        MetricMeasurement metricMeasurement = this.metricsMemory.remove(measurementId);
        long duration = System.nanoTime() - metricMeasurement.getTimeStarted();
        this.getMetricRegistry().simpleTimer(METRIC_NAME, this.getTags(metricMeasurement)).update(Duration.ofNanos(duration));
        this.LOG.tracef("(" + measurementId + ") Finished recording metrics for: %s", (Object)metricMeasurement.getName());
    }

    class VendorType
    extends AnnotationLiteral<RegistryType>
    implements RegistryType {
        VendorType() {
        }

        public MetricRegistry.Type type() {
            return MetricRegistry.Type.VENDOR;
        }
    }
}

