/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientError;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GraphQlClientException
extends RuntimeException {
    private final List<GraphQlClientError> errors;

    public GraphQlClientException(String message) {
        super(message);
        this.errors = Collections.emptyList();
    }

    public GraphQlClientException(String message, List<GraphQlClientError> errors) {
        super(message);
        this.errors = Objects.requireNonNull(errors);
    }

    public GraphQlClientException(String message, Throwable cause) {
        super(message, cause);
        this.errors = Collections.emptyList();
    }

    @Override
    public String toString() {
        return "GraphQlClientException: " + this.getMessage() + (this.errors.isEmpty() ? "" : "\nerrors:\n- " + this.errors.stream().map(Object::toString).collect(Collectors.joining("\n- "))) + ")";
    }

    public List<GraphQlClientError> getErrors() {
        return this.errors;
    }
}

