/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core;

import io.smallrye.graphql.client.core.FieldOrFragment;
import io.smallrye.graphql.client.core.FragmentOrOperation;
import io.smallrye.graphql.client.core.utils.ServiceUtils;
import java.util.Arrays;
import java.util.List;

public interface Fragment
extends FragmentOrOperation {
    public static List<Fragment> fragments(Fragment ... fragments) {
        return Arrays.asList(fragments);
    }

    public static FragmentBuilder fragment(String name) {
        return new FragmentBuilder(name);
    }

    public String getName();

    public void setName(String var1);

    public String getTargetType();

    public void setTargetType(String var1);

    public List<FieldOrFragment> getFields();

    public void setFields(List<FieldOrFragment> var1);

    public static class FragmentBuilder {
        private String name;
        private String targetType;
        private List<FieldOrFragment> fields;

        FragmentBuilder(String name) {
            this.name = name;
        }

        public Fragment on(String targetType, FieldOrFragment ... fields) {
            this.targetType = targetType;
            this.fields = Arrays.asList(fields);
            return this.build();
        }

        Fragment build() {
            Fragment fragment = ServiceUtils.getNewInstanceOf(Fragment.class);
            fragment.setName(this.name);
            fragment.setTargetType(this.targetType);
            fragment.setFields(this.fields);
            return fragment;
        }
    }
}

