/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import io.smallrye.graphql.client.GraphQLError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class ErrorOr<T> {
    private final T value;
    private final List<GraphQLError> errors;

    public static <T> ErrorOr<T> of(T value) {
        return new ErrorOr<T>(Objects.requireNonNull(value, "value must not be null"), null);
    }

    public static <T> ErrorOr<T> ofErrors(List<GraphQLError> errors) {
        if (errors == null) {
            throw new NullPointerException("errors must not be null");
        }
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("errors must not be empty");
        }
        return new ErrorOr<Object>(null, Collections.unmodifiableList(new ArrayList<GraphQLError>(errors)));
    }

    protected ErrorOr(T value, List<GraphQLError> errors) {
        this.value = value;
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorOr that = (ErrorOr)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.errors);
    }

    public String toString() {
        return "ErrorOr(" + (this.isPresent() ? "value=" + this.value : "errors=" + this.errors) + ")";
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean hasErrors() {
        return !this.isPresent();
    }

    public T get() {
        if (this.hasErrors()) {
            throw new NoSuchElementException("No value present, but " + this.errors);
        }
        return this.value;
    }

    public List<GraphQLError> getErrors() {
        if (this.isPresent()) {
            throw new NoSuchElementException("No error present, but value " + this.value);
        }
        return this.errors;
    }

    public void ifPresent(Consumer<? super T> action) {
        Objects.requireNonNull(action, "ifPresent action must not be null");
        if (this.isPresent()) {
            action.accept(this.value);
        }
    }

    public void handle(Consumer<? super T> dataAction, Consumer<List<GraphQLError>> errorsAction) {
        Objects.requireNonNull(dataAction, "handle dataAction must not be null");
        Objects.requireNonNull(errorsAction, "handle errorsAction must not be null");
        if (this.isPresent()) {
            dataAction.accept(this.value);
        } else {
            errorsAction.accept(this.errors);
        }
    }

    public <U> ErrorOr<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "map function must not be null");
        if (this.isPresent()) {
            return ErrorOr.of(mapper.apply(this.value));
        }
        return this;
    }

    public <U> ErrorOr<U> flatMap(Function<? super T, ErrorOr<U>> mapper) {
        Objects.requireNonNull(mapper, "flatMap function must not be null");
        if (this.isPresent()) {
            return mapper.apply(this.value);
        }
        return this;
    }

    public Optional<T> optional() {
        return this.isPresent() ? Optional.of(this.value) : Optional.empty();
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.value) : Stream.empty();
    }
}

