/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core;

import io.smallrye.graphql.client.core.Directive;
import io.smallrye.graphql.client.core.FieldOrFragment;
import io.smallrye.graphql.client.core.FragmentOrOperation;
import io.smallrye.graphql.client.core.factory.FragmentFactory;
import io.smallrye.graphql.client.core.utils.ServiceUtils;
import io.smallrye.graphql.client.core.utils.validation.NameValidation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface Fragment
extends FragmentOrOperation {
    public static List<Fragment> fragments(Fragment ... fragments) {
        return Arrays.asList(fragments);
    }

    public static FragmentBuilder fragment(String name) {
        return new FragmentBuilder(name);
    }

    public String getName();

    public void setName(String var1);

    public String getTargetType();

    public void setTargetType(String var1);

    public List<FieldOrFragment> getFields();

    public void setFields(List<FieldOrFragment> var1);

    public List<Directive> getDirectives();

    public void setDirectives(List<Directive> var1);

    public static class FragmentBuilder {
        private String name;
        private String targetType;
        private List<Directive> directives;
        private List<FieldOrFragment> fields;

        FragmentBuilder(String name) {
            this.name = NameValidation.validateFragmentName(name);
        }

        public Fragment on(String targetType, FieldOrFragment ... fields) {
            this.targetType = NameValidation.validateName(targetType);
            this.directives = Collections.emptyList();
            this.fields = Arrays.asList(fields);
            return this.build();
        }

        public Fragment on(String targetType, List<Directive> directives, FieldOrFragment ... fields) {
            this.targetType = NameValidation.validateName(targetType);
            this.directives = directives;
            this.fields = Arrays.asList(fields);
            return this.build();
        }

        Fragment build() {
            Fragment fragment = (Fragment)ServiceUtils.getNewInstanceFromFactory(FragmentFactory.class);
            fragment.setName(this.name);
            fragment.setTargetType(this.targetType);
            fragment.setDirectives(this.directives);
            fragment.setFields(this.fields);
            return fragment;
        }
    }
}

