/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core.utils.validation;

import java.util.regex.Pattern;

public class NameValidation {
    private static final String _IGNORED_TOKENS_REGEX = "[,\\s]*";
    private static final String _NAME_REGEX = "[,\\s]*[a-zA-Z_][a-zA-Z0-9_]*[,\\s]*";
    private static final String _FIELD_NAME_REGEX = "^[,\\s]*[a-zA-Z_][a-zA-Z0-9_]*[,\\s]*(:[,\\s]*[a-zA-Z_][a-zA-Z0-9_]*[,\\s]*)?$";
    private static final Pattern NAME_PATTERN = Pattern.compile("[,\\s]*[a-zA-Z_][a-zA-Z0-9_]*[,\\s]*");
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^[,\\s]*[a-zA-Z_][a-zA-Z0-9_]*[,\\s]*(:[,\\s]*[a-zA-Z_][a-zA-Z0-9_]*[,\\s]*)?$");

    public static String validateNameAllowEmpty(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!NameValidation.nameMatchesPattern(name, NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid name: '%s'. Name does not match the regex pattern %s, please check the GraphQL specification %s".formatted(name, _NAME_REGEX, "https://spec.graphql.org/draft/#Name"));
        }
        return name;
    }

    public static String validateFragmentName(String name) {
        if (name == null || !NameValidation.nameMatchesPattern(name, NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid fragment name '%s'. Fragment name does not match the regex pattern %s, please check the GraphQL specification %s".formatted(name, _NAME_REGEX, "https://spec.graphql.org/draft/#sec-Language.Fragments"));
        }
        if (name.equals("on")) {
            throw new IllegalArgumentException("Invalid fragment name. Fragment name cannot be 'on'");
        }
        return name;
    }

    public static String validateName(String name) {
        if (name == null || !NameValidation.nameMatchesPattern(name, NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid name: '%s'. Name does not match the regex pattern %s, please check the GraphQL specification %s".formatted(name, _NAME_REGEX, "https://spec.graphql.org/draft/#Name"));
        }
        return name;
    }

    public static String validateFieldName(String fieldName) {
        if (fieldName == null || !NameValidation.nameMatchesPattern(fieldName, FIELD_NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid field name: '%s'. Field name does not match the regex pattern %s, please check the GraphQL specification %s".formatted(fieldName, _FIELD_NAME_REGEX, "https://spec.graphql.org/draft/#sec-Language.Fields"));
        }
        return fieldName;
    }

    public static String validateTypeName(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Invalid type name. Type name cannot be null");
        }
        if (typeName.contains("]") || typeName.contains("[")) {
            throw new IllegalArgumentException("Invalid type name: '%s'. Type name cannot contain '[' or ']', instead use the io.smallrye.graphql.client.core.VariableType.list method to wrap your type into a list type".formatted(typeName));
        }
        if (typeName.contains("!")) {
            throw new IllegalArgumentException("Invalid type name: '%s'. Type name cannot contain '!', instead use the io.smallrye.graphql.client.core.VariableType.nonNull method to wrap your type into a non-null type".formatted(typeName));
        }
        if (!NameValidation.nameMatchesPattern(typeName, NAME_PATTERN)) {
            throw new IllegalArgumentException("Invalid type name: '%s'. Type name does not match the regex pattern %s, please check the GraphQL specification %s".formatted(typeName, _NAME_REGEX, "https://spec.graphql.org/draft/#sec-Type-References"));
        }
        return typeName;
    }

    private static boolean nameMatchesPattern(String name, Pattern pattern) {
        return pattern.matcher(name).matches();
    }
}

