/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core;

import io.smallrye.graphql.client.core.Buildable;
import io.smallrye.graphql.client.core.ScalarType;
import io.smallrye.graphql.client.core.utils.ServiceUtils;
import io.smallrye.graphql.client.core.utils.validation.NameValidation;

public interface VariableType
extends Buildable {
    public static VariableType varType(String objectTypeName) {
        VariableType varType = ServiceUtils.getNewInstanceOf(VariableType.class);
        varType.setName(NameValidation.validateName(objectTypeName));
        varType.setNonNull(false);
        varType.setChild(null);
        return varType;
    }

    public static VariableType varType(ScalarType scalarType) {
        VariableType varType = ServiceUtils.getNewInstanceOf(VariableType.class);
        varType.setName(scalarType.toString());
        varType.setNonNull(false);
        varType.setChild(null);
        return varType;
    }

    public static VariableType nonNull(ScalarType scalarType) {
        VariableType varType = ServiceUtils.getNewInstanceOf(VariableType.class);
        varType.setName(scalarType.toString());
        varType.setNonNull(true);
        varType.setChild(null);
        return varType;
    }

    public static VariableType nonNull(String objectTypeName) {
        VariableType varType = ServiceUtils.getNewInstanceOf(VariableType.class);
        varType.setName(NameValidation.validateName(objectTypeName));
        varType.setNonNull(true);
        varType.setChild(null);
        return varType;
    }

    public static VariableType nonNull(VariableType varType) {
        varType.setNonNull(true);
        return varType;
    }

    public static VariableType list(ScalarType scalarType) {
        VariableType varType = ServiceUtils.getNewInstanceOf(VariableType.class);
        varType.setName("list(" + scalarType.toString() + ")");
        varType.setNonNull(false);
        varType.setChild(VariableType.varType(scalarType));
        return varType;
    }

    public static VariableType list(String objectTypeName) {
        VariableType varType = ServiceUtils.getNewInstanceOf(VariableType.class);
        varType.setName("list(" + NameValidation.validateName(objectTypeName) + ")");
        varType.setNonNull(false);
        varType.setChild(VariableType.varType(objectTypeName));
        return varType;
    }

    public static VariableType list(VariableType childVarType) {
        VariableType varType = ServiceUtils.getNewInstanceOf(VariableType.class);
        varType.setName("list(" + childVarType.getName() + ")");
        varType.setNonNull(false);
        varType.setChild(childVarType);
        return varType;
    }

    public String getName();

    public void setName(String var1);

    public boolean isNonNull();

    public void setNonNull(boolean var1);

    public VariableType getChild();

    public void setChild(VariableType var1);

    default public boolean isList() {
        return this.getChild() != null;
    }
}

