/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic.vertx;

import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import io.smallrye.graphql.client.dynamic.vertx.VertxDynamicGraphQLClient;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.WebClientOptions;

public class VertxDynamicGraphQLClientBuilder
implements DynamicGraphQLClientBuilder {
    private Vertx vertx;
    private String url;
    private final MultiMap headersMap = new HeadersMultiMap();
    private WebClientOptions options;

    public VertxDynamicGraphQLClientBuilder() {
        this.headersMap.set("Content-Type", "application/json");
    }

    public VertxDynamicGraphQLClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder header(String name, String value) {
        this.headersMap.set(name, value);
        return this;
    }

    public VertxDynamicGraphQLClientBuilder options(WebClientOptions options) {
        this.options = options;
        return this;
    }

    public DynamicGraphQLClientBuilder url(String url) {
        this.url = url;
        return this;
    }

    public DynamicGraphQLClient build() {
        if (this.url == null) {
            throw new IllegalArgumentException("URL is required");
        }
        Vertx toUseVertx = this.vertx != null ? this.vertx : Vertx.vertx();
        return new VertxDynamicGraphQLClient(toUseVertx, this.url, this.headersMap, this.options);
    }
}

