/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.dynamic.vertx;

import io.smallrye.graphql.client.ErrorMessageProvider;
import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import io.smallrye.graphql.client.dynamic.vertx.VertxDynamicGraphQLClient;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.WebClientOptions;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;

public class VertxDynamicGraphQLClientBuilder
implements DynamicGraphQLClientBuilder {
    private Vertx vertx;
    private String url;
    private String configKey;
    private final MultiMap headersMap = new HeadersMultiMap();
    private WebClientOptions options;

    public VertxDynamicGraphQLClientBuilder() {
        this.headersMap.set("Content-Type", "application/json");
    }

    public VertxDynamicGraphQLClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder header(String name, String value) {
        this.headersMap.set(name, value);
        return this;
    }

    public VertxDynamicGraphQLClientBuilder options(WebClientOptions options) {
        this.options = options;
        return this;
    }

    public DynamicGraphQLClientBuilder url(String url) {
        this.url = url;
        return this;
    }

    public DynamicGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public DynamicGraphQLClient build() {
        if (this.configKey != null) {
            GraphQLClientConfiguration persistentConfig;
            try {
                persistentConfig = (GraphQLClientConfiguration)((GraphQLClientsConfiguration)CDI.current().select(GraphQLClientsConfiguration.class, new Annotation[0]).get()).getClients().get(this.configKey);
            }
            catch (IllegalStateException ex) {
                persistentConfig = null;
            }
            if (persistentConfig != null) {
                this.applyConfig(persistentConfig);
            }
        }
        if (this.url == null) {
            if (this.configKey == null) {
                throw SmallRyeGraphQLClientMessages.msg.urlNotConfiguredForProgrammaticClient();
            }
            throw ErrorMessageProvider.get().urlMissingErrorForNamedClient(this.configKey);
        }
        Vertx toUseVertx = this.vertx != null ? this.vertx : Vertx.vertx();
        return new VertxDynamicGraphQLClient(toUseVertx, this.url, this.headersMap, this.options);
    }

    private void applyConfig(GraphQLClientConfiguration configuration) {
        if (this.url == null && configuration.getUrl() != null) {
            this.url = configuration.getUrl();
        }
        configuration.getHeaders().forEach((k, v) -> {
            if (!this.headersMap.contains(k)) {
                this.headersMap.set(k, v);
            }
        });
    }
}

