/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.vertx;

import io.smallrye.graphql.client.ErrorMessageProvider;
import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.vertx.VertxTypesafeGraphQLClientProxy;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.AccessController;
import java.util.Collections;

public class VertxTypesafeGraphQLClientBuilder
implements TypesafeGraphQLClientBuilder {
    private static Vertx VERTX;
    private String configKey = null;
    private URI endpoint;
    private Vertx vertx;
    private WebClientOptions options;
    private WebClient webClient;

    public TypesafeGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public TypesafeGraphQLClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public TypesafeGraphQLClientBuilder client(WebClient webClient) {
        this.webClient = webClient;
        return this;
    }

    public TypesafeGraphQLClientBuilder options(WebClientOptions options) {
        this.options = options;
        return this;
    }

    public TypesafeGraphQLClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        GraphQLClientsConfiguration configs;
        GraphQLClientConfiguration persistentConfig;
        if (this.configKey == null) {
            this.configKey = this.configKey(apiClass);
        }
        if ((persistentConfig = (configs = GraphQLClientsConfiguration.getInstance()).getClient(this.configKey)) == null) {
            configs.addTypesafeClientApis(Collections.singletonList(apiClass));
            persistentConfig = configs.getClient(this.configKey);
        }
        if (persistentConfig != null) {
            this.applyConfig(persistentConfig);
        }
        if (this.endpoint == null) {
            throw ErrorMessageProvider.get().urlMissingErrorForNamedClient(this.configKey);
        }
        VertxTypesafeGraphQLClientProxy graphQlClient = new VertxTypesafeGraphQLClientProxy(persistentConfig, this.endpoint, this.webClient());
        return apiClass.cast(Proxy.newProxyInstance(this.getClassLoader(apiClass), new Class[]{apiClass}, (proxy, method, args) -> this.invoke(apiClass, graphQlClient, method, args)));
    }

    private WebClient webClient() {
        if (this.webClient == null) {
            HttpClient httpClient = this.options != null ? this.vertx().createHttpClient((HttpClientOptions)this.options) : this.vertx().createHttpClient();
            this.webClient = WebClient.wrap((HttpClient)httpClient);
        }
        return this.webClient;
    }

    private Vertx vertx() {
        if (this.vertx == null) {
            Context vertxContext = Vertx.currentContext();
            if (vertxContext != null && vertxContext.owner() != null) {
                this.vertx = vertxContext.owner();
            } else {
                if (VERTX == null) {
                    VERTX = Vertx.vertx();
                }
                this.vertx = VERTX;
            }
        }
        return this.vertx;
    }

    private Object invoke(Class<?> apiClass, VertxTypesafeGraphQLClientProxy graphQlClient, Method method, Object ... args) {
        MethodInvocation methodInvocation = MethodInvocation.of((Method)method, (Object[])args);
        if (methodInvocation.isDeclaredInCloseable()) {
            graphQlClient.close();
            return null;
        }
        return graphQlClient.invoke(apiClass, methodInvocation);
    }

    private ClassLoader getClassLoader(Class<?> apiClass) {
        if (System.getSecurityManager() == null) {
            return apiClass.getClassLoader();
        }
        return AccessController.doPrivileged(apiClass::getClassLoader);
    }

    private void applyConfig(GraphQLClientConfiguration configuration) {
        if (this.endpoint == null && configuration.getUrl() != null) {
            this.endpoint = URI.create(configuration.getUrl());
        }
    }

    private String configKey(Class<?> apiClass) {
        GraphQLClientApi annotation = apiClass.getAnnotation(GraphQLClientApi.class);
        if (annotation == null) {
            return apiClass.getName();
        }
        String keyFromAnnotation = annotation.configKey();
        return keyFromAnnotation.isEmpty() ? apiClass.getName() : keyFromAnnotation;
    }
}

