/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.dynamic;

import io.smallrye.graphql.client.Request;
import io.smallrye.graphql.client.Response;
import io.smallrye.graphql.client.core.Document;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.impl.RequestImpl;
import io.smallrye.graphql.client.impl.ResponseReader;
import io.smallrye.graphql.client.vertx.websocket.BuiltinWebsocketSubprotocolHandlers;
import io.smallrye.graphql.client.vertx.websocket.WebSocketSubprotocolHandler;
import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import org.jboss.logging.Logger;

public class VertxDynamicGraphQLClient
implements DynamicGraphQLClient {
    private static final Logger log = Logger.getLogger(VertxDynamicGraphQLClient.class);
    private final WebClient webClient;
    private final HttpClient httpClient;
    private final String url;
    private final MultiMap headers;
    private final List<WebsocketSubprotocol> subprotocols;

    VertxDynamicGraphQLClient(Vertx vertx, String url, MultiMap headers, WebClientOptions options, List<WebsocketSubprotocol> subprotocols) {
        this.httpClient = options != null ? vertx.createHttpClient((HttpClientOptions)options) : vertx.createHttpClient();
        this.webClient = WebClient.wrap((HttpClient)this.httpClient);
        this.headers = headers;
        this.url = url;
        this.subprotocols = subprotocols;
    }

    public Response executeSync(Document document) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, null, null));
    }

    public Response executeSync(Document document, Map<String, Object> variables) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, variables, null));
    }

    public Response executeSync(Document document, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, null, operationName));
    }

    public Response executeSync(Document document, Map<String, Object> variables, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(this.buildRequest(document, variables, operationName));
    }

    public Response executeSync(Request request) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)request.toJson()));
    }

    public Response executeSync(String query) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, null, null).toJson()));
    }

    public Response executeSync(String query, Map<String, Object> variables) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, variables, null).toJson()));
    }

    public Response executeSync(String query, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, null, operationName).toJson()));
    }

    public Response executeSync(String query, Map<String, Object> variables, String operationName) throws ExecutionException, InterruptedException {
        return this.executeSync(Buffer.buffer((String)this.buildRequest(query, variables, operationName).toJson()));
    }

    private Response executeSync(Buffer buffer) throws ExecutionException, InterruptedException {
        HttpResponse result = (HttpResponse)this.webClient.postAbs(this.url).putHeaders(this.headers).sendBuffer(buffer).toCompletionStage().toCompletableFuture().get();
        return ResponseReader.readFrom((String)result.bodyAsString(), this.convertHeaders(result.headers()));
    }

    private Map<String, List<String>> convertHeaders(MultiMap input) {
        return input.entries().stream().collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public Uni<Response> executeAsync(Document document) {
        return this.executeAsync(this.buildRequest(document, null, null));
    }

    public Uni<Response> executeAsync(Document document, Map<String, Object> variables) {
        return this.executeAsync(this.buildRequest(document, variables, null));
    }

    public Uni<Response> executeAsync(Document document, String operationName) {
        return this.executeAsync(this.buildRequest(document, null, operationName));
    }

    public Uni<Response> executeAsync(Document document, Map<String, Object> variables, String operationName) {
        return this.executeAsync(this.buildRequest(document, variables, operationName));
    }

    public Uni<Response> executeAsync(Request request) {
        return this.executeAsync(Buffer.buffer((String)request.toJson()));
    }

    public Uni<Response> executeAsync(String query) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, null, null).toJson()));
    }

    public Uni<Response> executeAsync(String query, Map<String, Object> variables) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, variables, null).toJson()));
    }

    public Uni<Response> executeAsync(String query, String operationName) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, null, operationName).toJson()));
    }

    public Uni<Response> executeAsync(String query, Map<String, Object> variables, String operationName) {
        return this.executeAsync(Buffer.buffer((String)this.buildRequest(query, variables, operationName).toJson()));
    }

    private Uni<Response> executeAsync(Buffer buffer) {
        return Uni.createFrom().completionStage(this.webClient.postAbs(this.url).putHeaders(this.headers).sendBuffer(buffer).toCompletionStage()).map(response -> ResponseReader.readFrom((String)response.bodyAsString(), this.convertHeaders(response.headers())));
    }

    public Multi<Response> subscription(Document document) {
        return this.subscription0(this.buildRequest(document, null, null).toJsonObject());
    }

    public Multi<Response> subscription(Document document, Map<String, Object> variables) {
        return this.subscription0(this.buildRequest(document, variables, null).toJsonObject());
    }

    public Multi<Response> subscription(Document document, String operationName) {
        return this.subscription0(this.buildRequest(document, null, operationName).toJsonObject());
    }

    public Multi<Response> subscription(Document document, Map<String, Object> variables, String operationName) {
        return this.subscription0(this.buildRequest(document, variables, operationName).toJsonObject());
    }

    public Multi<Response> subscription(Request request) {
        return this.subscription0(request.toJsonObject());
    }

    public Multi<Response> subscription(String query) {
        return this.subscription0(this.buildRequest(query, null, null).toJsonObject());
    }

    public Multi<Response> subscription(String query, Map<String, Object> variables) {
        return this.subscription0(this.buildRequest(query, variables, null).toJsonObject());
    }

    public Multi<Response> subscription(String query, String operationName) {
        return this.subscription0(this.buildRequest(query, null, operationName).toJsonObject());
    }

    public Multi<Response> subscription(String query, Map<String, Object> variables, String operationName) {
        return this.subscription0(this.buildRequest(query, variables, operationName).toJsonObject());
    }

    private Multi<Response> subscription0(JsonObject requestJson) {
        String WSURL = this.url.replaceFirst("http", "ws");
        List subprotocolIds = this.subprotocols == null ? Collections.emptyList() : this.subprotocols.stream().map(i -> i.getProtocolId()).collect(Collectors.toList());
        AtomicReference handlerReference = new AtomicReference();
        return Multi.createFrom().emitter(emitter -> this.httpClient.webSocketAbs(WSURL, this.headers, WebsocketVersion.V13, subprotocolIds, result -> {
            if (result.succeeded()) {
                WebSocket webSocket = (WebSocket)result.result();
                WebSocketSubprotocolHandler handler = BuiltinWebsocketSubprotocolHandlers.createHandlerFor(webSocket.subProtocol());
                handlerReference.set(handler);
                log.debug((Object)("Using websocket subprotocol handler: " + handler));
                Multi rawData = Multi.createFrom().emitter(rawEmitter -> handler.handleWebSocketStart(requestJson, (MultiEmitter<? super String>)rawEmitter, webSocket));
                rawData.subscribe().with(data -> emitter.emit((Object)ResponseReader.readFrom((String)data, Collections.emptyMap())), failure -> emitter.fail(failure), () -> emitter.complete());
            } else {
                emitter.fail(result.cause());
            }
        })).onTermination().invoke(() -> {
            WebSocketSubprotocolHandler handler = (WebSocketSubprotocolHandler)handlerReference.get();
            if (handler != null) {
                handler.handleCancel();
            }
        });
    }

    private Request buildRequest(Document document, Map<String, Object> variables, String operationName) {
        return this.buildRequest(document.build(), variables, operationName);
    }

    private Request buildRequest(String query, Map<String, Object> variables, String operationName) {
        RequestImpl request = new RequestImpl(query);
        if (variables != null) {
            request.setVariables(variables);
        }
        if (operationName != null && !operationName.isEmpty()) {
            request.setOperationName(operationName);
        }
        return request;
    }

    public void close() {
        this.httpClient.close();
    }
}

