/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.dynamic;

import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import io.smallrye.graphql.client.impl.ErrorMessageProvider;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.vertx.dynamic.VertxDynamicGraphQLClient;
import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import io.vertx.core.Context;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;

public class VertxDynamicGraphQLClientBuilder
implements DynamicGraphQLClientBuilder {
    private static final Logger log = Logger.getLogger(VertxDynamicGraphQLClientBuilder.class);
    private Vertx vertx;
    private String url;
    private String configKey;
    private final MultiMap headersMap = new HeadersMultiMap();
    private WebClientOptions options;
    private List<WebsocketSubprotocol> subprotocols;

    public VertxDynamicGraphQLClientBuilder() {
        this.headersMap.set("Content-Type", "application/json");
        this.subprotocols = new ArrayList<WebsocketSubprotocol>();
    }

    public VertxDynamicGraphQLClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public VertxDynamicGraphQLClientBuilder header(String name, String value) {
        this.headersMap.set(name, value);
        return this;
    }

    public VertxDynamicGraphQLClientBuilder options(WebClientOptions options) {
        this.options = options;
        return this;
    }

    public DynamicGraphQLClientBuilder subprotocols(WebsocketSubprotocol ... subprotocols) {
        this.subprotocols.addAll(Arrays.asList(subprotocols));
        return this;
    }

    public DynamicGraphQLClientBuilder url(String url) {
        this.url = url;
        return this;
    }

    public DynamicGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public DynamicGraphQLClient build() {
        Context vertxContext;
        GraphQLClientConfiguration persistentConfig;
        if (this.configKey != null && (persistentConfig = GraphQLClientsConfiguration.getInstance().getClient(this.configKey)) != null) {
            this.applyConfig(persistentConfig);
        }
        if (this.url == null) {
            if (this.configKey == null) {
                throw SmallRyeGraphQLClientMessages.msg.urlNotConfiguredForProgrammaticClient();
            }
            throw ErrorMessageProvider.get().urlMissingErrorForNamedClient(this.configKey);
        }
        Vertx toUseVertx = this.vertx != null ? this.vertx : ((vertxContext = Vertx.currentContext()) != null && vertxContext.owner() != null ? vertxContext.owner() : Vertx.vertx());
        return new VertxDynamicGraphQLClient(toUseVertx, this.url, this.headersMap, this.options, this.subprotocols);
    }

    private void applyConfig(GraphQLClientConfiguration configuration) {
        if (this.url == null && configuration.getUrl() != null) {
            this.url = configuration.getUrl();
        }
        configuration.getHeaders().forEach((k, v) -> {
            if (!this.headersMap.contains(k)) {
                this.headersMap.set(k, v);
            }
        });
        if (configuration.getWebsocketSubprotocols() != null) {
            configuration.getWebsocketSubprotocols().forEach(protocol -> {
                try {
                    WebsocketSubprotocol e = WebsocketSubprotocol.fromString((String)protocol);
                    this.subprotocols.add(e);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e);
                }
            });
        }
    }
}

