/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model;

import io.smallrye.graphql.client.model.ScanningContext;
import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.TypesafeResponse;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class Classes {
    private static final DotName UNI = DotName.createSimple((String)Uni.class.getName());
    private static final DotName MULTI = DotName.createSimple((String)Multi.class.getName());
    public static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final DotName COLLECTION = DotName.createSimple((String)Collection.class.getName());
    public static final DotName LIST = DotName.createSimple((String)List.class.getName());
    public static final DotName LINKED_LIST = DotName.createSimple((String)LinkedList.class.getName());
    public static final DotName VECTOR = DotName.createSimple((String)Vector.class.getName());
    public static final DotName ARRAY_LIST = DotName.createSimple((String)ArrayList.class.getName());
    public static final DotName STACK = DotName.createSimple((String)Stack.class.getName());
    public static final DotName SET = DotName.createSimple((String)Set.class.getName());
    public static final DotName HASH_SET = DotName.createSimple((String)HashSet.class.getName());
    public static final DotName SORTED_SET = DotName.createSimple((String)SortedSet.class.getName());
    public static final DotName TREE_SET = DotName.createSimple((String)TreeSet.class.getName());
    public static final DotName QUEUE = DotName.createSimple((String)Queue.class.getName());
    public static final DotName DEQUE = DotName.createSimple((String)Deque.class.getName());
    public static final DotName MAP = DotName.createSimple((String)Map.class.getName());
    public static final DotName HASH_MAP = DotName.createSimple((String)HashMap.class.getName());
    public static final DotName TREE_MAP = DotName.createSimple((String)TreeMap.class.getName());
    public static final DotName HASHTABLE = DotName.createSimple((String)Hashtable.class.getName());
    public static final DotName SORTED_MAP = DotName.createSimple((String)SortedMap.class.getName());
    public static final DotName OPTIONAL = DotName.createSimple((String)Optional.class.getName());
    public static final DotName TYPESAFE_RESPONSE = DotName.createSimple((String)TypesafeResponse.class.getName());
    public static final DotName ERROR_OR = DotName.createSimple((String)ErrorOr.class.getName());
    private static final DotName INTEGER_OPTIONAL = DotName.createSimple((String)OptionalInt.class.getName());
    private static final DotName DOUBLE_OPTIONAL = DotName.createSimple((String)OptionalDouble.class.getName());
    private static final DotName LONG_OPTIONAL = DotName.createSimple((String)OptionalLong.class.getName());
    private static final List<DotName> KNOWN_COLLECTIONS = new ArrayList<DotName>();
    private static final List<DotName> KNOWN_MAPS = new ArrayList<DotName>();

    private Classes() {
    }

    public static boolean isParameterized(Type type) {
        return type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public static boolean isTypeVariable(Type type) {
        return type.kind().equals((Object)Type.Kind.TYPE_VARIABLE);
    }

    public static boolean isOptional(Type type) {
        return Classes.isParameterized(type) && type.name().equals((Object)OPTIONAL) || type.name().equals((Object)LONG_OPTIONAL) || type.name().equals((Object)DOUBLE_OPTIONAL) || type.name().equals((Object)INTEGER_OPTIONAL);
    }

    public static boolean isEnum(Type type) {
        if (Classes.isClass(type)) {
            ClassInfo clazz = ScanningContext.getIndex().getClassByName(type.asClassType().name());
            return clazz != null && clazz.isEnum();
        }
        return false;
    }

    public static boolean isAsync(Type type) {
        return Classes.isUni(type) || Classes.isMulti(type);
    }

    public static boolean isInterface(Type type) {
        if (Classes.isClass(type)) {
            ClassInfo clazz = ScanningContext.getIndex().getClassByName(type.asClassType().name());
            return clazz != null && clazz.isInterface();
        }
        return false;
    }

    public static boolean isUni(Type type) {
        return type.name().equals((Object)UNI);
    }

    public static boolean isMulti(Type type) {
        return type.name().equals((Object)MULTI);
    }

    public static boolean isPrimitive(Type type) {
        return type.kind().equals((Object)Type.Kind.PRIMITIVE);
    }

    public static boolean isClass(Type type) {
        return type.kind().equals((Object)Type.Kind.CLASS);
    }

    public static boolean isArray(Type type) {
        return type.kind().equals((Object)Type.Kind.ARRAY);
    }

    public static boolean isCollection(Type type) {
        if (Classes.isParameterized(type)) {
            ClassInfo clazz = ScanningContext.getIndex().getClassByName(type.name());
            if (clazz == null) {
                try {
                    Class<?> clazzLoaded = Classes.class.getClassLoader().loadClass(type.name().toString());
                    return Collection.class.isAssignableFrom(clazzLoaded);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Info not found in Jandex index nor classpath for class name:" + type.name());
                }
            }
            if (KNOWN_COLLECTIONS.contains(clazz.name())) {
                return true;
            }
            for (Type intf : clazz.interfaceTypes()) {
                if (!Classes.isCollection(intf)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMap(Type type) {
        if (Classes.isParameterized(type)) {
            ClassInfo clazz = ScanningContext.getIndex().getClassByName(type.name());
            if (clazz == null) {
                try {
                    Class<?> clazzLoaded = Classes.class.getClassLoader().loadClass(type.name().toString());
                    return Map.class.isAssignableFrom(clazzLoaded);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Info not found in Jandex index nor classpath for class name:" + type.name());
                }
            }
            if (KNOWN_MAPS.contains(clazz.name())) {
                return true;
            }
            for (Type intf : clazz.interfaceTypes()) {
                if (!Classes.isMap(intf)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        KNOWN_COLLECTIONS.add(COLLECTION);
        KNOWN_COLLECTIONS.add(LIST);
        KNOWN_COLLECTIONS.add(LINKED_LIST);
        KNOWN_COLLECTIONS.add(VECTOR);
        KNOWN_COLLECTIONS.add(ARRAY_LIST);
        KNOWN_COLLECTIONS.add(STACK);
        KNOWN_COLLECTIONS.add(SET);
        KNOWN_COLLECTIONS.add(HASH_SET);
        KNOWN_COLLECTIONS.add(SORTED_SET);
        KNOWN_COLLECTIONS.add(TREE_SET);
        KNOWN_COLLECTIONS.add(QUEUE);
        KNOWN_COLLECTIONS.add(DEQUE);
        KNOWN_MAPS.add(MAP);
        KNOWN_MAPS.add(HASH_MAP);
        KNOWN_MAPS.add(TREE_MAP);
        KNOWN_MAPS.add(HASHTABLE);
        KNOWN_MAPS.add(SORTED_MAP);
    }
}

