/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model;

import io.smallrye.graphql.client.model.helper.DirectiveInstance;
import io.smallrye.graphql.client.model.helper.OperationModel;
import java.util.stream.Collectors;
import org.jboss.jandex.MethodInfo;

public class QueryBuilder {
    private final OperationModel method;

    public QueryBuilder(MethodInfo method) {
        this.method = OperationModel.of(method);
    }

    public String build() {
        StringBuilder request = new StringBuilder(this.method.getOperationTypeAsString());
        request.append(" ");
        request.append(this.method.getName());
        if (this.method.hasValueParameters()) {
            request.append(this.method.valueParameters().stream().map(this.method::declare).collect(Collectors.joining(", ", "(", ")")));
        }
        if (this.method.isSingle()) {
            request.append(" { ");
            request.append(this.method.getName());
            if (this.method.hasRootParameters()) {
                request.append(this.method.rootParameters().stream().map(this.method::bind).collect(Collectors.joining(", ", "(", ")")));
            }
            if (this.method.hasDirectives()) {
                request.append(this.method.getDirectives().stream().map(DirectiveInstance::buildDirective).collect(Collectors.joining()));
            }
        }
        request.append(this.method.fields(this.method.getReturnType()));
        if (this.method.isSingle()) {
            request.append(" }");
        }
        return request.toString();
    }
}

