/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model;

import java.util.Arrays;
import java.util.Objects;

public class MethodKey {
    private Class<?> declaringClass;
    private String methodName;
    private Class<?>[] parameterTypes;

    public MethodKey(Class<?> declaringClass, String methodName, Class<?>[] parameterTypes) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public MethodKey() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodKey methodKey = (MethodKey)o;
        return Objects.equals(this.declaringClass, methodKey.declaringClass) && Objects.equals(this.methodName, methodKey.methodName) && Arrays.equals(this.parameterTypes, methodKey.parameterTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringClass, this.methodName);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public String toString() {
        return "MethodKey{declaringClass=" + this.declaringClass + ", methodName='" + this.methodName + "', parameterTypes=" + Arrays.toString(this.parameterTypes) + "}";
    }
}

