/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientApi;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientBuilder;
import io.smallrye.graphql.client.typesafe.impl.GraphQlClientProxy;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.AccessController;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.eclipse.microprofile.config.ConfigProvider;

public class GraphQlClientBuilderImpl
implements GraphQlClientBuilder {
    private String configKey = null;
    private Client client = DEFAULT_CLIENT;
    private URI endpoint;
    private static final Client DEFAULT_CLIENT = ClientBuilder.newClient();

    public GraphQlClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public GraphQlClientBuilder client(Client client) {
        this.client = client;
        return this;
    }

    public GraphQlClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GraphQlClientBuilder register(Class<?> componentClass) {
        this.client.register(componentClass);
        return this;
    }

    public GraphQlClientBuilder register(Object component) {
        this.client.register(component);
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        this.readConfig(apiClass.getAnnotation(GraphQlClientApi.class));
        WebTarget webTarget = this.client.target(this.resolveEndpoint(apiClass));
        GraphQlClientProxy graphQlClient = new GraphQlClientProxy(webTarget);
        return apiClass.cast(Proxy.newProxyInstance(this.getClassLoader(apiClass), new Class[]{apiClass}, (proxy, method, args) -> graphQlClient.invoke(apiClass, MethodInvocation.of(method, args))));
    }

    private ClassLoader getClassLoader(Class<?> apiClass) {
        if (System.getSecurityManager() == null) {
            return apiClass.getClassLoader();
        }
        return AccessController.doPrivileged(apiClass::getClassLoader);
    }

    private void readConfig(GraphQlClientApi annotation) {
        if (annotation == null) {
            return;
        }
        if (this.endpoint == null && !annotation.endpoint().isEmpty()) {
            this.endpoint = URI.create(annotation.endpoint());
        }
        if (this.configKey == null && !annotation.configKey().isEmpty()) {
            this.configKey = annotation.configKey();
        }
    }

    private URI resolveEndpoint(Class<?> apiClass) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        return (URI)ConfigProvider.getConfig().getValue(this.configKey(apiClass) + "/mp-graphql/url", URI.class);
    }

    private String configKey(Class<?> apiClass) {
        return this.configKey == null ? apiClass.getName() : this.configKey;
    }
}

