/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.impl.reflection.ParameterInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.Stack;
import java.util.stream.Collectors;

class QueryBuilder {
    private final MethodInvocation method;
    private final Stack<String> typeStack = new Stack();

    public QueryBuilder(MethodInvocation method) {
        this.method = method;
    }

    String build() {
        StringBuilder request = new StringBuilder();
        request.append(this.method.isQuery() ? "query " : "mutation ");
        request.append(this.method.getName());
        if (this.method.hasValueParameters()) {
            request.append(this.method.valueParameters().map(this::declare).collect(Collectors.joining(", ", "(", ")")));
        }
        request.append(" { ");
        request.append(this.method.getName());
        if (this.method.hasValueParameters()) {
            request.append(this.method.valueParameters().map(this::bind).collect(Collectors.joining(", ", "(", ")")));
        }
        request.append(this.fields(this.method.getReturnType()));
        request.append(" }");
        return request.toString();
    }

    private String declare(ParameterInfo parameter) {
        return "$" + parameter.getName() + ": " + parameter.graphQlInputTypeName();
    }

    private String bind(ParameterInfo parameter) {
        return parameter.getName() + ": $" + parameter.getName();
    }

    private String fields(TypeInfo type) {
        if (this.typeStack.contains(type.getTypeName())) {
            throw new GraphQlClientException("field recursion found");
        }
        try {
            this.typeStack.push(type.getTypeName());
            String string = this.recursionCheckedFields(type);
            return string;
        }
        finally {
            this.typeStack.pop();
        }
    }

    private String recursionCheckedFields(TypeInfo type) {
        while (type.isOptional() || type.isErrorOr()) {
            type = type.getItemType();
        }
        if (type.isScalar()) {
            return "";
        }
        if (type.isCollection()) {
            return this.fields(type.getItemType());
        }
        return type.fields().map(this::field).collect(Collectors.joining(" ", " {", "}"));
    }

    private String field(FieldInfo field) {
        TypeInfo type = field.getType();
        if (type.isScalar() || type.isCollection() && type.getItemType().isScalar()) {
            return field.getName();
        }
        return field.getName() + this.fields(type);
    }
}

